<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0017"
	title    = "ロールマスタ"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />
<og:entry command="{@command}" />

<!-- 物理削除以外の場合は、自身の行が、活動中かどうかをﾁｪｯｸします。 -->
<og:equals val1="DELETE" val2="{@sqlType}" notEquals="true" >
	<og:dataCheck
		command	= "{@command}"
		from	= "GEA05"
		where	= "UNIQ=[UNIQ] AND SYSTEM_ID=[SYSTEM_ID]"
	/>
</og:equals>


<!-- COPY の場合は、すでに、同一論理キーのデータが存在すれば、エラーにします。 -->
<!-- 7.2.9.2 (2020/10/30) 条件に、INSERT も追加 -->
<og:equals val1="COPY|INSERT" val2="{@sqlType}" contains="true">
	<og:dataCheck
		command = "{@command}"
		exist	= "false"
		from	= "GEA05"
		where	= "SYSTEM_ID=[SYSTEM_ID] AND ROLES=[ROLES] AND KBROLE=[KBROLE] AND FGJ = '1'"
	/>

	<!-- メモリ内での重複ﾁｪｯｸ -->
	<og:dataCheck
		command			= "{@command}"
		uniqCheckClms	= "SYSTEM_ID,KBROLE"
	/>
</og:equals>

<og:tableUpdate
	command			= "{@command}"
	queryType		= "JDBCTableUpdate">
	<og:tableUpdateParam
		sqlType			= "{@sqlType}"
		table			= "GEA05"
		where			= "UNIQ=[UNIQ] AND SYSTEM_ID=[SYSTEM_ID]"
		names			= "SYSTEM_ID,ROLES,NMROLE,KBROLE"
		logicalDelete	= "{@logicalDelete}"
	/>
</og:tableUpdate>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
