/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* GFP20001 ( PACKAGE BODY )                                                */
/* Created : 2020/11/13 12:37:10                                            */
/****************************************************************************/

CREATE 
PACKAGE BODY GFP20001 AS
/*******************************************************************************
*	ｼｽﾃﾑ			:	フレームワーク雛形
*	ﾌﾟﾛｸﾞﾗﾑID		:	GFP20001
*	処理名			:	バッチ処理サンプル(共通ＳＰ呼び出し)
*	作成日			:	2007/09/01
*	作成者			:	XXXXXXXXX
*	更新日/更新者	:
*	更新内容		:
*******************************************************************************/
PROCEDURE GF20001 (
	 PO_STATUS		OUT		NUMBER												-- ｽﾃｰﾀｽ(0:正常 1:異常)
	,PO_ERR_CODE	OUT		VARCHAR2											-- ｴﾗｰﾒｯｾｰｼﾞ
	,PI_JOBID		IN		VARCHAR2											-- ｼﾞｮﾌﾞID
)
IS
/*******************************************************************************
*	変数宣言
*******************************************************************************/
	-- 定数定義
	CON_MIDDB				CONSTANT	VARCHAR2(100)	:= 'GFP20001';			-- ﾓｼﾞｭｰﾙID
	CON_NMRTN				CONSTANT	VARCHAR2(100)	:= 'ﾊﾞｯﾁ処理ｻﾝﾌﾟﾙ'; 	-- 処理名
	CON_PGID				CONSTANT	VARCHAR2(10)	:= 'GFP20001';			-- ﾌﾟﾛｸﾞﾗﾑID
	CON_PGPID				CONSTANT	VARCHAR2(100)	:= PI_JOBID;			-- ｼﾞｮﾌﾞID
	CON_SYSDATE				CONSTANT	VARCHAR2(14)	:= TO_CHAR(SYSDATE,'YYYYMMDDHH24MISS');	-- ｼｽﾃﾑ日付
	CON_USER				CONSTANT	VARCHAR2(10)	:= SUBSTRB(USER,1,10);	-- ログインユーザー

	-- 必須変数定義
	G_ERRSTP				VARCHAR2(1000)	:= NULL;							-- ｴﾗｰﾒｯｾｰｼﾞ
	G_STATUS				NUMBER			:= 0;								-- 結果判定用ｽﾃｰﾀｽ
	G_ERR_CODE				VARCHAR2(1000)	:= NULL;							-- ｴﾗｰｺｰﾄﾞ
	G_DISP_KEY				VARCHAR2(1000)	:= NULL;							-- ｷｰ項目
	G_RTN					BOOLEAN;											-- ﾘﾀｰﾝ値

	-- 共通SP必須変数定義
	G_ERRMSGS				ERR_MSG_ARRAY;										-- ｴﾗｰﾒｯｾｰｼﾞ配列
	-- 件数ｶｳﾝﾄ用変数定義
	G_GFW41_SEL_CNT			NUMBER	:= 0;										-- ﾗﾍﾞﾙ定義WK読込み件数
	G_GF41_INS_CNT			NUMBER	:= 0;										-- ﾗﾍﾞﾙ定義追加件数
	-- ｶｰｿﾙ定義
	-- ﾗﾍﾞﾙ定義WKｶｰｿﾙ定義
	CURSOR GFW41_C01 IS
		SELECT	 SYSTEM_ID
				,LANG
				,CLM
				,NAME_JA
				,LABEL_NAME
				,KBSAKU
		FROM	GFW41;

	-- ﾚｺｰﾄﾞ定義
	GFW41_R01	GFW41_C01%ROWTYPE;												--ﾗﾍﾞﾙ定義WKｶｰｿﾙ型

	-- EXCEPTION定義
	USER_EXPT EXCEPTION;

	-- ｻﾌﾞﾌﾟﾛｸﾞﾗﾑ
	FUNCTION LOCAL_MSG_RTN (LI_MSG	IN	VARCHAR2) RETURN BOOLEAN;
	FUNCTION INIT_PROCESS_RTN RETURN BOOLEAN;
	FUNCTION END_PROCESS_RTN RETURN BOOLEAN;
	FUNCTION GFP00001_CALL_RTN RETURN BOOLEAN;

/*******************************************************************************
*	LOCAL_MSG_RTN ﾒｯｾｰｼﾞ出力
*******************************************************************************/
FUNCTION LOCAL_MSG_RTN (
	LI_MSG	IN	VARCHAR2
)
RETURN BOOLEAN
IS
BEGIN
/*
	-- 統合ｻｰﾊﾞｰ用
	MSG_RTN(G_STATUS
			,G_ERR_CODE
			,CON_MIDDB
			,CON_PGPID
			,CON_PGID
			,CON_NMRTN
			,NULL
			,NULL
			,SUBSTRB(LI_MSG,1,1000)
			);
*/
	-- 統合ｻｰﾊﾞｰ以外
	DBMS_OUTPUT.PUT_LINE(LI_MSG);
	RETURN TRUE;
END LOCAL_MSG_RTN;
--
/*******************************************************************************
*	INIT_PROCESS_RTN 初期処理
*******************************************************************************/
FUNCTION INIT_PROCESS_RTN
RETURN BOOLEAN
IS
BEGIN
	G_ERRSTP		:= 'INIT_PROCESS_RTN';
	-- ｽﾃｰﾀｽ(1:異常)
	PO_STATUS	:= 1;

	-- 統合ｻｰﾊﾞｰ用
	G_STATUS		:= 0;
	G_ERR_CODE		:= NULL;

	-- 開始ﾛｸﾞ出力
	G_RTN := LOCAL_MSG_RTN('*** '||CON_MIDDB||' ('||CON_NMRTN||') START ***');

	RETURN TRUE;
END INIT_PROCESS_RTN;
/*******************************************************************************
*	END_PROCESS_RTN 終了処理
*******************************************************************************/
FUNCTION END_PROCESS_RTN
RETURN BOOLEAN
IS
BEGIN
	G_ERRSTP		:= 'END_PROCESS_RTN';

	IF	GFW41_C01%ISOPEN THEN
		CLOSE GFW41_C01;
	END IF;

	-- ﾛｸﾞ出力
	G_RTN := LOCAL_MSG_RTN('*** GFW41  ｶﾗﾑ定義WK読込件数     = ' || TO_CHAR(G_GFW41_SEL_CNT));
	G_RTN := LOCAL_MSG_RTN('*** GF41   ｶﾗﾑ定義追加件数       = ' || TO_CHAR(G_GF41_INS_CNT));
	G_RTN := LOCAL_MSG_RTN('*** '||CON_PGID||' ('||CON_NMRTN||') END ***');
--
	-- ｺﾐｯﾄ
	COMMIT;
	-- ｽﾃｰﾀｽ(0:正常)
	PO_STATUS	:= 0;

	/*
	-- 統合ｻｰﾊﾞｰ用
	NOREND_RTN(G_STATUS
				,G_ERR_CODE
				,CON_MIDDB
				,CON_PGPID
				,CON_PGID
				,CON_NMRTN
				,NULL
				,NULL
				,'正常終了しました。'
				);
*/

	RETURN TRUE;
END END_PROCESS_RTN;
/*******************************************************************************
*	GFP00001_CALL_RTN
*******************************************************************************/
FUNCTION GFP00001_CALL_RTN
RETURN BOOLEAN
IS
	L_STATUS	NUMBER(1);														-- ｴﾗｰ結果
BEGIN
	G_ERRSTP	:=	'GFP00001_CALL_RTN';
	G_DISP_KEY	:=	' SYSTEM_ID='|| GFW41_R01.SYSTEM_ID||
					' LANG='|| GFW41_R01.LANG||
					' CLM='|| GFW41_R01.CLM;

	GFP00001.GF00001(
					 L_STATUS													-- ｽﾃｰﾀｽ
					,G_ERRMSGS													-- ｴﾗｰﾒｯｾｰｼﾞ配列
					,CON_PGID													-- 画面ID
					,G_GFW41_SEL_CNT											-- 行番号
					,GFW41_R01.SYSTEM_ID										-- ｼｽﾃﾑID
					,GFW41_R01.LANG												-- 言語
					,GFW41_R01.CLM												-- 項目
					,GFW41_R01.NAME_JA											-- 名称（漢字）
					,GFW41_R01.LABEL_NAME										-- 表示名称
					,GFW41_R01.KBSAKU											-- 作成区分
					,NULL														-- 担当者
					,CON_USER													-- ﾛｸﾞｲﾝﾕｰｻﾞｰ
					);

	--ｽﾃｰﾀｽが9（ｵﾗｸﾙｴﾗｰ発生）が返ってきた場合は必ずHYBS.COMMONSP_ERRORをRAISEします。
	IF	(L_STATUS = 9) THEN
    	RAISE HYBS.COMMONSP_ERROR;
    --ｽﾃｰﾀｽが1（異常）の場合の処理は任意です
    ELSIF	(L_STATUS = 1) THEN
    	--行いたい処理（例えばRETURN FALSE）に書き換えて下さい。
    	NULL;
	END IF;

	RETURN TRUE;
END GFP00001_CALL_RTN;
/*******************************************************************************
*	ﾒｲﾝ処理
*******************************************************************************/
BEGIN
	-- 初期処理
	G_RTN := INIT_PROCESS_RTN;
	-- ｶﾗﾑ定義WK
	OPEN GFW41_C01;
	LOOP
		FETCH GFW41_C01 INTO GFW41_R01;
		EXIT WHEN GFW41_C01%NOTFOUND;
		-- ｶﾗﾑ定義WK読込み件数
		G_GFW41_SEL_CNT := G_GFW41_SEL_CNT + 1;

		-- ｷｰ項目
		G_DISP_KEY := ' SYSTEM_ID='|| GFW41_R01.SYSTEM_ID||
					  ' LANG=' || GFW41_R01.LANG||
					  ' CLM=' || GFW41_R01.CLM;

		-- ｶﾗﾑ定義登録処理
		G_RTN := GFP00001_CALL_RTN;
		-- ｶﾗﾑ定義追加件数
		G_GF41_INS_CNT := G_GF41_INS_CNT + 1;

	END LOOP;
	CLOSE GFW41_C01;

	-- 終了処理
	G_RTN := END_PROCESS_RTN;

/*******************************************************************************
*	異常処理
/******************************************************************************/
EXCEPTION
	-- 共通SPｴﾗｰ
	WHEN HYBS.COMMONSP_ERROR THEN
		IF GFW41_C01%ISOPEN THEN
			CLOSE GFW41_C01;
		END IF;
		-- ﾛｰﾙﾊﾞｯｸ
		ROLLBACK;
		-- ｽﾃｰﾀｽ(1:異常)
		PO_STATUS		:= 1;
		-- 共通SPでｾｯﾄしたｴﾗｰﾒｯｾｰｼﾞ配列のﾛｸﾞ出力
		HYBS.OUTPUT_ERRMSGS(G_ERRMSGS,CON_PGPID,CON_NMRTN);
/*
		-- 統合ｻｰﾊﾞｰ用
		ABEND_RTN(G_STATUS
			,G_ERR_CODE
			,CON_MIDDB
			,CON_PGPID
			,CON_PGID
			,CON_NMRTN
			,TO_CHAR(SQLCODE)
			,G_DISP_KEY
			,SUBSTR(G_ERRSTP,1,1000));
*/
		-- 統合ｻｰﾊﾞｰ以外
		DBMS_OUTPUT.PUT_LINE('ABEND '||CON_PGPID||' '||CON_MIDDB||
						' SQLCODE = '||TO_CHAR(SQLCODE)||' '||G_DISP_KEY||' '||
						SUBSTR(G_ERRSTP,1,100));
	-- ｵﾗｸﾙｴﾗｰ
	WHEN OTHERS THEN
		IF GFW41_C01%ISOPEN THEN
			CLOSE GFW41_C01;
		END IF;
		-- ﾛｰﾙﾊﾞｯｸ
		ROLLBACK;
		-- ｽﾃｰﾀｽ(1:異常)
		PO_STATUS		:= 1;
		-- 共通SPでセットしたｴﾗｰﾒｯｾｰｼﾞ配列のﾛｸﾞ出力
		HYBS.OUTPUT_ERRMSGS(G_ERRMSGS,CON_PGPID,CON_NMRTN);
/*
		ROLLBACK;
		-- 統合ｻｰﾊﾞｰ用
		ABEND_RTN(G_STATUS
			,G_ERR_CODE
			,CON_MIDDB
			,CON_PGPID
			,CON_PGID
			,CON_NMRTN
			,TO_CHAR(SQLCODE)
			,G_DISP_KEY
			,SUBSTR(G_ERRSTP,1,1000));
*/
		-- 統合ｻｰﾊﾞｰ以外
		DBMS_OUTPUT.PUT_LINE('ABEND '||CON_PGPID||' '||CON_MIDDB||
						' SQLCODE = '||TO_CHAR(SQLCODE)||' '||G_DISP_KEY||' '||
						SUBSTR(G_ERRSTP,1,100));
END GF20001;
END GFP20001;
;
