<jsp:directive.page pageEncoding="UTF-8" />

<!-- ORACLE 版 -->
<og:equals val1="{@DBF.NAME @DBID}" val2="ORACLE">
	<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
		select A.OBJECT_NAME AS OBJ_NAME,B.LINE AS SEQNO,'' AS CLM ,
				'' AS CLS_NAME,'' AS USE_LENGTH,'' AS CLM_NAME,
				'' AS TABLE_NAME ,'' AS MAX_LENGTH,
				B.TEXT , 
				'{@TBLSYU}' AS TBLSYU,'{@SYSTEM_ID}' AS SYSTEM_ID
		from USER_OBJECTS A inner join USER_SOURCE B
		on    A.OBJECT_NAME = B.NAME
		and   A.OBJECT_TYPE = B.TYPE
		where A.OBJECT_TYPE = 'TYPE'
		and   not A.OBJECT_NAME like '%ARRAY'
		order by A.OBJECT_NAME,B.LINE
	</og:query>

	<!-- テキストから、オブジェクト名、カラム名、クラス、利用桁数を切り出す。 -->
	<og:tableFilter classId="DBARG"
			keys="TEXT,OBJ_NAME,SEQNO,CLM,CLS_NAME,USE_LENGTH,CLM_NAME,MAX_LENGTH"
			vals="TEXT,OBJ_NAME,SEQNO,CLM,CLS_NAME,USE_LENGTH,CLM_NAME,MAX_LENGTH"
	/>

	<!-- 最も適合すると思われるテーブル名を取得する。 -->
	<!-- ﾘﾌｧﾚﾝｽ上で、TABLEとTYPEを両方含むｵﾌﾞｼﾞｪｸﾄと、そのﾃｰﾌﾞﾙのｶﾗﾑをﾋﾟｯｸｱｯﾌﾟして、先の検索結果とﾏｰｼﾞします。 -->
	<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0" scope="request">
		select B.REFERENCED_NAME AS OBJ_NAME , A.REFERENCED_NAME AS TABLE_NAME, C.COLUMN_NAME AS CLM , count(*) as CNT
		from ( USER_DEPENDENCIES A inner join USER_DEPENDENCIES B
				on  A.NAME = B.NAME
				and A.REFERENCED_TYPE='TABLE'
				and B.REFERENCED_TYPE='TYPE' ) inner join USER_TAB_COLUMNS C
					on  A.REFERENCED_NAME = C.TABLE_NAME
		where not A.NAME like '%ARRAY'
		group by A.REFERENCED_NAME,B.REFERENCED_NAME, C.COLUMN_NAME
		order by B.REFERENCED_NAME, C.COLUMN_NAME, CNT DESC, B.REFERENCED_NAME
	</og:query>

	<!-- 取り出したテーブル名を、マージする。 -->
	<og:tableMerge
		action     = "UNION_CLM"
		slaveKeys  = "OBJ_NAME,CLM"
		unionClms  = "TABLE_NAME"
	/>
</og:equals>

<!-- ORACLE 以外の場合 -->
<og:equals val1="ORACLE" val2="{@DBF.NAME @DBID}" contains="true" notEquals="true">
	<!-- GFE0009 : {0} は、{1} のデータベースに対応していません。 -->
	<og:message lbl="GFE0009" val0="{@LBL.GF2070}" val1="{@DBF.NAME @DBID}" />
</og:equals>

<!-- CLM_NAME にリソースを適用します。 -->
<og:tableFilter classId="LABEL" keys="SYSTEM_ID,CLM,LBL" vals="{@SYSTEM_ID},CLM,CLM_NAME" />
