/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import org.firebirdsql.jdbc.DefaultCallableStatementMetaData;
import org.firebirdsql.jdbc.DummyCallableStatementMetaData;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FirebirdDatabaseMetaData;
import org.firebirdsql.jdbc.StoredProcedureMetaData;

public abstract class StoredProcedureMetaDataFactory {
    public static StoredProcedureMetaData getInstance(FBConnection connection) throws SQLException {
        if (StoredProcedureMetaDataFactory.connectionHasProcedureMetadata(connection)) {
            return new DefaultCallableStatementMetaData(connection);
        }
        return new DummyCallableStatementMetaData();
    }

    private static boolean connectionHasProcedureMetadata(FBConnection connection) throws SQLException {
        FirebirdDatabaseMetaData metaData = (FirebirdDatabaseMetaData)connection.getMetaData();
        return StoredProcedureMetaDataFactory.versionInformationEqualOrAbove(metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion(), 2, 1) && StoredProcedureMetaDataFactory.versionInformationEqualOrAbove(metaData.getOdsMajorVersion(), metaData.getOdsMinorVersion(), 2, 1);
    }

    private static boolean versionInformationEqualOrAbove(int majorVersion, int minorVersion, int requiredMajorVersion, int requiredMinorVersion) {
        return majorVersion > requiredMajorVersion || majorVersion == requiredMajorVersion && minorVersion >= requiredMinorVersion;
    }
}

