/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl.argument;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.argument.Argument;
import org.firebirdsql.gds.impl.argument.ArgumentType;

public final class NumericArgument
extends Argument {
    private static final EnumSet<ArgumentType> SUPPORTED_ARGUMENT_TYPES = EnumSet.of(ArgumentType.TraditionalDpb, ArgumentType.Wide, ArgumentType.IntSpb, ArgumentType.ByteSpb);
    private final ArgumentType argumentType;
    private final int value;

    public NumericArgument(int type, ArgumentType argumentType, int value) {
        super(type);
        if (!SUPPORTED_ARGUMENT_TYPES.contains((Object)argumentType)) {
            throw new IllegalArgumentException("Invalid argument type: " + (Object)((Object)argumentType));
        }
        this.argumentType = argumentType;
        this.value = value;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.getType());
        this.writeValue(outputStream, this.value);
    }

    @Override
    public int getLength() {
        if (this.argumentType == ArgumentType.ByteSpb) {
            return 2;
        }
        return 5 + this.argumentType.getLengthSize();
    }

    protected void writeValue(OutputStream outputStream, int value) throws IOException {
        if (this.argumentType == ArgumentType.ByteSpb) {
            outputStream.write(value);
        } else {
            this.argumentType.writeLength(4, outputStream);
            VaxEncoding.encodeVaxIntegerWithoutLength(outputStream, value);
        }
    }

    @Override
    public final int getValueAsInt() {
        return this.value;
    }

    @Override
    public long getValueAsLong() {
        return this.value;
    }

    @Override
    public void copyTo(ParameterBuffer buffer, Encoding encoding) {
        buffer.addArgument(this.getType(), this.value);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof NumericArgument)) {
            return false;
        }
        NumericArgument otherNumericArgument = (NumericArgument)other;
        return this.getType() == otherNumericArgument.getType() && this.value == otherNumericArgument.value;
    }

    @Override
    public int hashCode() {
        int result = 23;
        result = 41 * result + this.getType();
        result = 41 * result + this.value;
        return result;
    }
}

