/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.firebirdsql.gds.ParameterBufferHelper;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.TransactionParameterBufferImpl;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jdbc.FirebirdConnectionProperties;

public class FBTpbMapper
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1690658870275668176L;
    public static final String TRANSACTION_SERIALIZABLE = "TRANSACTION_SERIALIZABLE";
    public static final String TRANSACTION_REPEATABLE_READ = "TRANSACTION_REPEATABLE_READ";
    public static final String TRANSACTION_READ_COMMITTED = "TRANSACTION_READ_COMMITTED";
    private static final List<String> ISOLATION_LEVEL_NAMES = Collections.unmodifiableList(Arrays.asList("TRANSACTION_SERIALIZABLE", "TRANSACTION_REPEATABLE_READ", "TRANSACTION_READ_COMMITTED"));
    public static final String TRANSACTION_READ_UNCOMMITTED = "TRANSACTION_READ_UNCOMMITTED";
    public static final String TRANSACTION_NONE = "TRANSACTION_NONE";
    private Map<Integer, TransactionParameterBuffer> mapping = new ConcurrentHashMap<Integer, TransactionParameterBuffer>();
    private int defaultIsolationLevel = 2;

    public static FBTpbMapper getDefaultMapper() {
        return new FBTpbMapper();
    }

    public static String getTransactionIsolationName(int isolationLevel) {
        switch (isolationLevel) {
            case 0: {
                return TRANSACTION_NONE;
            }
            case 1: {
                return TRANSACTION_READ_UNCOMMITTED;
            }
            case 2: {
                return TRANSACTION_READ_COMMITTED;
            }
            case 4: {
                return TRANSACTION_REPEATABLE_READ;
            }
            case 8: {
                return TRANSACTION_SERIALIZABLE;
            }
        }
        throw new IllegalArgumentException("Incorrect transaction isolation level.");
    }

    public static int getTransactionIsolationLevel(String isolationName) {
        switch (isolationName) {
            case "TRANSACTION_NONE": {
                return 0;
            }
            case "TRANSACTION_READ_UNCOMMITTED": {
                return 1;
            }
            case "TRANSACTION_READ_COMMITTED": {
                return 2;
            }
            case "TRANSACTION_REPEATABLE_READ": {
                return 4;
            }
            case "TRANSACTION_SERIALIZABLE": {
                return 8;
            }
        }
        throw new IllegalArgumentException("Invalid isolation name.");
    }

    public FBTpbMapper() {
        TransactionParameterBufferImpl serializableTpb = new TransactionParameterBufferImpl();
        serializableTpb.addArgument(9);
        serializableTpb.addArgument(6);
        serializableTpb.addArgument(1);
        TransactionParameterBufferImpl repeatableReadTpb = new TransactionParameterBufferImpl();
        repeatableReadTpb.addArgument(9);
        repeatableReadTpb.addArgument(6);
        repeatableReadTpb.addArgument(2);
        TransactionParameterBufferImpl readCommittedTpb = new TransactionParameterBufferImpl();
        readCommittedTpb.addArgument(9);
        readCommittedTpb.addArgument(6);
        readCommittedTpb.addArgument(15);
        readCommittedTpb.addArgument(17);
        this.mapping.put(8, serializableTpb);
        this.mapping.put(4, repeatableReadTpb);
        this.mapping.put(2, readCommittedTpb);
    }

    public FBTpbMapper(Map<String, String> stringMapping) throws FBResourceException {
        this();
        this.processMapping(stringMapping);
    }

    private void processMapping(Map<String, String> stringMapping) throws FBResourceException {
        for (Map.Entry<String, String> entry : stringMapping.entrySet()) {
            Integer isolationLevel;
            String jdbcTxIsolation = entry.getKey();
            try {
                isolationLevel = FBTpbMapper.getTransactionIsolationLevel(jdbcTxIsolation);
            }
            catch (IllegalArgumentException ex) {
                throw new FBResourceException("Transaction isolation " + jdbcTxIsolation + " is not supported.");
            }
            TransactionParameterBuffer tpb = FBTpbMapper.processMapping(entry.getValue());
            this.mapping.put(isolationLevel, tpb);
        }
    }

    public FBTpbMapper(String mappingResource, ClassLoader cl) throws FBResourceException {
        try {
            ResourceBundle res = ResourceBundle.getBundle(mappingResource, Locale.getDefault(), cl);
            HashMap<String, String> mapping = new HashMap<String, String>();
            Enumeration<String> en = res.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                String value = res.getString(key);
                mapping.put(key, value);
            }
            this.processMapping(mapping);
        }
        catch (MissingResourceException mrex) {
            throw new FBResourceException("Cannot load TPB mapping." + mrex.getMessage());
        }
    }

    public static void processMapping(FirebirdConnectionProperties connectionProperties, Properties info) throws FBResourceException {
        for (String isolationName : ISOLATION_LEVEL_NAMES) {
            String property = info.getProperty(isolationName);
            if (property == null) continue;
            connectionProperties.setTransactionParameters(FBTpbMapper.getTransactionIsolationLevel(isolationName), FBTpbMapper.processMapping(property));
        }
    }

    public static TransactionParameterBuffer processMapping(String mapping) throws FBResourceException {
        TransactionParameterBufferImpl result = new TransactionParameterBufferImpl();
        StringTokenizer st = new StringTokenizer(mapping, ",");
        while (st.hasMoreTokens()) {
            Integer value;
            String token = st.nextToken();
            Integer argValue = null;
            if (token.contains("=")) {
                String[] parts = token.split("=");
                try {
                    argValue = Integer.valueOf(parts[1]);
                }
                catch (NumberFormatException ex) {
                    throw new FBResourceException(parts[1] + " is not valid integer value");
                }
                token = parts[0];
            }
            if ((value = ParameterBufferHelper.getTpbParam(token)) == null) {
                throw new FBResourceException("Keyword " + token + " unknown. Please check your mapping.");
            }
            if (argValue == null) {
                result.addArgument(value);
                continue;
            }
            result.addArgument((int)value, argValue);
        }
        return result;
    }

    public TransactionParameterBuffer getMapping(int transactionIsolation) {
        switch (transactionIsolation) {
            case 2: 
            case 4: 
            case 8: {
                return this.mapping.get(transactionIsolation).deepCopy();
            }
            case 1: {
                return this.mapping.get(2).deepCopy();
            }
        }
        throw new IllegalArgumentException("Transaction isolation level " + transactionIsolation + " is not supported.");
    }

    public void setMapping(int transactionIsolation, TransactionParameterBuffer tpb) {
        switch (transactionIsolation) {
            case 2: 
            case 4: 
            case 8: {
                this.mapping.put(transactionIsolation, tpb.deepCopy());
                break;
            }
            default: {
                throw new IllegalArgumentException("Transaction isolation level " + transactionIsolation + " is not supported.");
            }
        }
    }

    public TransactionParameterBuffer getDefaultMapping() {
        return this.mapping.get(this.defaultIsolationLevel);
    }

    public int getDefaultTransactionIsolation() {
        return this.defaultIsolationLevel;
    }

    public void setDefaultTransactionIsolation(int isolationLevel) {
        this.defaultIsolationLevel = isolationLevel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FBTpbMapper)) {
            return false;
        }
        FBTpbMapper that = (FBTpbMapper)obj;
        boolean result = this.mapping.equals(that.mapping);
        return result &= this.defaultIsolationLevel == that.defaultIsolationLevel;
    }

    public int hashCode() {
        return Objects.hash(this.mapping, this.defaultIsolationLevel);
    }

    public Object clone() {
        try {
            FBTpbMapper clone = (FBTpbMapper)super.clone();
            ConcurrentHashMap<Integer, TransactionParameterBuffer> newMapping = new ConcurrentHashMap<Integer, TransactionParameterBuffer>();
            for (Map.Entry<Integer, TransactionParameterBuffer> entry : this.mapping.entrySet()) {
                newMapping.put(entry.getKey(), entry.getValue().deepCopy());
            }
            clone.mapping = newMapping;
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("Assertion failure: clone not supported");
        }
    }
}

