/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.SQLTransientException;
import java.sql.SQLWarning;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.firebirdsql.gds.ng.AbstractFbDatabase;
import org.firebirdsql.gds.ng.ExecutionPlanProcessor;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.SqlCountHolder;
import org.firebirdsql.gds.ng.SqlCountProcessor;
import org.firebirdsql.gds.ng.StatementInfoProcessor;
import org.firebirdsql.gds.ng.StatementState;
import org.firebirdsql.gds.ng.StatementType;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.fields.FieldValue;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.ExceptionListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListenerDispatcher;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.gds.ng.listeners.StatementListenerDispatcher;
import org.firebirdsql.gds.ng.listeners.TransactionListener;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public abstract class AbstractFbStatement
implements FbStatement {
    private static final Set<StatementState> RESET_TO_PREPARED = Collections.unmodifiableSet(EnumSet.of(StatementState.EXECUTING, StatementState.CURSOR_OPEN));
    private static final Logger log = LoggerFactory.getLogger(AbstractFbStatement.class);
    private final Object syncObject;
    private final WarningMessageCallback warningCallback = new WarningMessageCallback(){

        @Override
        public void processWarning(SQLWarning warning) {
            AbstractFbStatement.this.statementListenerDispatcher.warningReceived(AbstractFbStatement.this, warning);
        }
    };
    protected final StatementListenerDispatcher statementListenerDispatcher = new StatementListenerDispatcher();
    protected final ExceptionListenerDispatcher exceptionListenerDispatcher = new ExceptionListenerDispatcher(this);
    private volatile boolean allRowsFetched = false;
    private volatile StatementState state = StatementState.NEW;
    private volatile StatementType type = StatementType.NONE;
    private volatile RowDescriptor parameterDescriptor;
    private volatile RowDescriptor fieldDescriptor;
    private volatile FbTransaction transaction;
    private final TransactionListener transactionListener = new TransactionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transactionStateChanged(FbTransaction transaction, TransactionState newState, TransactionState previousState) {
            if (AbstractFbStatement.this.getTransaction() != transaction) {
                transaction.removeTransactionListener(this);
                return;
            }
            switch (newState) {
                case COMMITTED: 
                case ROLLED_BACK: {
                    Object object = AbstractFbStatement.this.getSynchronizationObject();
                    synchronized (object) {
                        try {
                            if (RESET_TO_PREPARED.contains((Object)AbstractFbStatement.this.getState())) {
                                try {
                                    AbstractFbStatement.this.switchState(StatementState.PREPARED);
                                }
                                catch (SQLException e) {
                                    throw new IllegalStateException("Received an SQLException when none was expected", e);
                                }
                                AbstractFbStatement.this.reset(false);
                            }
                            break;
                        }
                        finally {
                            transaction.removeTransactionListener(this);
                            try {
                                AbstractFbStatement.this.setTransaction(null);
                            }
                            catch (SQLException e) {
                                throw new IllegalStateException("Received an SQLException when none was expected", e);
                            }
                        }
                    }
                }
            }
        }
    };
    private static final Set<StatementState> PREPARE_ALLOWED_STATES = Collections.unmodifiableSet(EnumSet.of(StatementState.NEW, StatementState.ALLOCATED, StatementState.PREPARED));

    protected AbstractFbStatement(Object syncObject) {
        this.syncObject = syncObject;
    }

    protected final TransactionListener getTransactionListener() {
        return this.transactionListener;
    }

    protected final WarningMessageCallback getStatementWarningCallback() {
        return this.warningCallback;
    }

    protected final Object getSynchronizationObject() {
        return this.syncObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.getState() == StatementState.CLOSED) {
            return;
        }
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                try {
                    StatementState currentState = this.getState();
                    this.forceState(StatementState.CLOSING);
                    if (currentState != StatementState.NEW) {
                        this.free(2);
                    }
                }
                finally {
                    this.forceState(StatementState.CLOSED);
                    this.setType(StatementType.NONE);
                    this.statementListenerDispatcher.shutdown();
                    this.setTransaction(null);
                }
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            this.exceptionListenerDispatcher.shutdown();
        }
    }

    @Override
    public final void closeCursor() throws SQLException {
        this.closeCursor(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void closeCursor(boolean transactionEnd) throws SQLException {
        try {
            Object object = this.getSynchronizationObject();
            synchronized (object) {
                if (!this.getState().isCursorOpen()) {
                    return;
                }
                try {
                    if (!transactionEnd && this.getType().isTypeWithCursor()) {
                        this.free(1);
                    }
                    this.switchState(StatementState.PREPARED);
                }
                catch (SQLException e) {
                    this.switchState(StatementState.ERROR);
                    throw e;
                }
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public StatementState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void switchState(StatementState newState) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            StatementState currentState = this.state;
            if (currentState == newState || currentState == StatementState.CLOSED) {
                return;
            }
            if (!currentState.isValidTransition(newState)) {
                throw new SQLNonTransientException(String.format("Statement state %s only allows next states %s, received %s", new Object[]{currentState, currentState.validTransitionSet(), newState}));
            }
            this.state = newState;
            this.statementListenerDispatcher.statementStateChanged(this, newState, currentState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceState(StatementState newState) {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            StatementState currentState = this.state;
            if (currentState == newState || currentState == StatementState.CLOSED) {
                return;
            }
            if (log.isDebugEnabled() && !currentState.isValidTransition(newState)) {
                log.debug(String.format("Forced statement transition is invalid; state %s only allows next states %s, forced to set %s", new Object[]{currentState, currentState.validTransitionSet(), newState}), new IllegalStateException());
            }
            this.state = newState;
            this.statementListenerDispatcher.statementStateChanged(this, newState, currentState);
        }
    }

    @Override
    public final StatementType getType() {
        return this.type;
    }

    protected void setType(StatementType type) {
        this.type = type;
    }

    protected final void queueRowData(RowValue rowData) {
        this.statementListenerDispatcher.receivedRow(this, rowData);
    }

    protected final void setAllRowsFetched(boolean allRowsFetched) {
        this.allRowsFetched = allRowsFetched;
        if (allRowsFetched) {
            this.statementListenerDispatcher.allRowsFetched(this);
        }
    }

    protected final boolean isAllRowsFetched() {
        return this.allRowsFetched;
    }

    protected final void reset() {
        this.reset(false);
    }

    protected final void resetAll() {
        this.reset(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset(boolean resetAll) {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.setAllRowsFetched(false);
            if (resetAll) {
                this.setParameterDescriptor(null);
                this.setFieldDescriptor(null);
                this.setType(StatementType.NONE);
            }
        }
    }

    protected boolean isPrepareAllowed(StatementState state) {
        return PREPARE_ALLOWED_STATES.contains((Object)state);
    }

    @Override
    public final RowDescriptor getParameterDescriptor() {
        return this.parameterDescriptor;
    }

    protected void setParameterDescriptor(RowDescriptor parameterDescriptor) {
        this.parameterDescriptor = parameterDescriptor;
    }

    @Override
    public final RowDescriptor getFieldDescriptor() {
        return this.fieldDescriptor;
    }

    protected void setFieldDescriptor(RowDescriptor fieldDescriptor) {
        this.fieldDescriptor = fieldDescriptor;
    }

    public byte[] getStatementInfoRequestItems() {
        return ((AbstractFbDatabase)this.getDatabase()).getStatementInfoRequestItems();
    }

    public byte[] getParameterDescriptionInfoRequestItems() {
        return ((AbstractFbDatabase)this.getDatabase()).getParameterDescriptionInfoRequestItems();
    }

    @Override
    public final <T> T getSqlInfo(byte[] requestItems, int bufferLength, InfoProcessor<T> infoProcessor) throws SQLException {
        byte[] sqlInfo = this.getSqlInfo(requestItems, bufferLength);
        try {
            return infoProcessor.process(sqlInfo);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public final String getExecutionPlan() throws SQLException {
        ExecutionPlanProcessor processor = this.createExecutionPlanProcessor();
        return this.getSqlInfo(processor.getDescribePlanInfoItems(), this.getDefaultSqlInfoSize(), processor);
    }

    protected ExecutionPlanProcessor createExecutionPlanProcessor() {
        return new ExecutionPlanProcessor(this);
    }

    @Override
    public SqlCountHolder getSqlCounts() throws SQLException {
        try {
            this.checkStatementValid();
            if (this.getState() == StatementState.CURSOR_OPEN && !this.isAllRowsFetched()) {
                throw new SQLNonTransientException("Cursor still open, fetch all rows or close cursor before fetching SQL counts");
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        SqlCountProcessor countProcessor = this.createSqlCountProcessor();
        SqlCountHolder sqlCounts = this.getSqlInfo(countProcessor.getRecordCountInfoItems(), 64, countProcessor);
        this.statementListenerDispatcher.sqlCounts(this, sqlCounts);
        return sqlCounts;
    }

    protected SqlCountProcessor createSqlCountProcessor() {
        return new SqlCountProcessor();
    }

    protected abstract void free(int var1) throws SQLException;

    protected void validateParameters(RowValue parameters) throws SQLException {
        RowDescriptor parameterDescriptor = this.getParameterDescriptor();
        int expectedSize = parameterDescriptor != null ? parameterDescriptor.getCount() : 0;
        int actualSize = parameters.getCount();
        if (actualSize != expectedSize) {
            throw new SQLNonTransientException(String.format("Invalid number of parameters, expected %d, got %d", expectedSize, actualSize), "07008");
        }
        for (int fieldIndex = 0; fieldIndex < actualSize; ++fieldIndex) {
            FieldValue fieldValue = parameters.getFieldValue(fieldIndex);
            if (fieldValue != null && fieldValue.isInitialized()) continue;
            throw new SQLTransientException(String.format("Parameter with index %d was not set", fieldIndex + 1), "0700C");
        }
    }

    @Override
    public final void addStatementListener(StatementListener statementListener) {
        if (this.getState() == StatementState.CLOSED) {
            return;
        }
        this.statementListenerDispatcher.addListener(statementListener);
    }

    @Override
    public final void removeStatementListener(StatementListener statementListener) {
        this.statementListenerDispatcher.removeListener(statementListener);
    }

    @Override
    public final void addExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.addListener(listener);
    }

    @Override
    public final void removeExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.removeListener(listener);
    }

    protected final void checkStatementValid() throws SQLException {
        switch (this.getState()) {
            case NEW: {
                throw new SQLNonTransientException("Statement not yet allocated", "24000");
            }
            case CLOSING: 
            case CLOSED: {
                throw new SQLNonTransientException("Statement closed", "24000");
            }
            case ERROR: {
                throw new SQLNonTransientException("Statement is in error state and needs to be closed");
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.getState() != StatementState.CLOSED) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public FbTransaction getTransaction() {
        return this.transaction;
    }

    protected abstract boolean isValidTransactionClass(Class<? extends FbTransaction> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setTransaction(FbTransaction newTransaction) throws SQLException {
        block9: {
            try {
                if (newTransaction == null || this.isValidTransactionClass(newTransaction.getClass())) {
                    Object object = this.getSynchronizationObject();
                    synchronized (object) {
                        if (newTransaction == this.transaction) {
                            return;
                        }
                        if (this.transaction != null) {
                            this.transaction.removeTransactionListener(this.getTransactionListener());
                        }
                        this.transaction = newTransaction;
                        if (newTransaction != null) {
                            newTransaction.addTransactionListener(this.getTransactionListener());
                        }
                        break block9;
                    }
                }
                throw new SQLNonTransientException(String.format("Invalid transaction handle type, got \"%s\"", newTransaction.getClass().getName()), "HY000");
            }
            catch (SQLNonTransientException e) {
                this.exceptionListenerDispatcher.errorOccurred(e);
                throw e;
            }
        }
    }

    protected void parseStatementInfo(byte[] statementInfoResponse) throws SQLException {
        StatementInfoProcessor infoProcessor = new StatementInfoProcessor(this, this.getDatabase());
        InfoProcessor.StatementInfo statementInfo = infoProcessor.process(statementInfoResponse);
        this.setType(statementInfo.getStatementType());
        this.setFieldDescriptor(statementInfo.getFields());
        this.setParameterDescriptor(statementInfo.getParameters());
    }

    protected final boolean hasSingletonResult() {
        return this.getType().isTypeWithSingletonResult() && this.hasFields();
    }

    protected final boolean hasFields() {
        RowDescriptor fieldDescriptor = this.getFieldDescriptor();
        return fieldDescriptor != null && fieldDescriptor.getCount() > 0;
    }
}

