/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

final class FBDateField
extends FBField {
    FBDateField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Timestamp(this.getDatatypeCoder().decodeDateCalendar(this.getFieldData(), cal).getTime());
    }

    @Override
    public Timestamp getTimestamp() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Timestamp(this.getDate().getTime());
    }

    @Override
    public Date getDate(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeDateCalendar(this.getFieldData(), cal);
    }

    @Override
    public Date getDate() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeDate(this.getFieldData());
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeDate(this.getFieldData()).toString();
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setDate(Date.valueOf(value));
    }

    @Override
    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeDateCalendar(new Date(value.getTime()), cal));
    }

    @Override
    public void setTimestamp(Timestamp value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setDate(new Date(value.getTime()));
    }

    @Override
    public void setDate(Date value, Calendar cal) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeDateCalendar(value, cal));
    }

    @Override
    public void setDate(Date value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeDate(value));
    }

    @Override
    public DatatypeCoder.RawDateTimeStruct getRawDateTimeStruct() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeDateRaw(this.getFieldData());
    }

    @Override
    public void setRawDateTimeStruct(DatatypeCoder.RawDateTimeStruct raw) throws SQLException {
        if (raw == null) {
            this.setNull();
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeDateRaw(raw));
    }
}

