<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
    xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:mis="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java mis" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
              omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />

  <xsl:param name="row_header" >
     <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
     <SOURCE    ><xsl:value-of select="$ADDRESS"    /></SOURCE>
     <FILENAME  ><xsl:value-of select="$FILENAME"  /></FILENAME>
     <FILEPATH  ><xsl:value-of select="$FILEPATH"  /></FILEPATH>
     <MODIFIED  ><xsl:value-of select="$MODIFIED"  /></MODIFIED>
  </xsl:param>


 
 
  <xsl:template match="/">
    <xsl:apply-templates select="//mis:column[@name]" mode="name"/>
    <xsl:apply-templates select="//mis:select[@name]"  mode="name"/>
    <xsl:apply-templates select="//mis:columnEditor[@column]"   mode="column"/>
    <xsl:apply-templates select="//mis:columnMarker[@column]"   mode="column" />
    <xsl:apply-templates select="//mis:columnCheck[@columns]"   mode="column" />
    <xsl:apply-templates select="//mis:link[@columns]"   mode="column" />
    <xsl:apply-templates select="//mis:popup[@columns]"   mode="column" />
    <xsl:apply-templates select="//mis:columnEditor[@columns]"   mode="columns" />
    <xsl:apply-templates select="//mis:columnMarker[@columns]"   mode="columns" />
    <xsl:apply-templates select="//mis:input[@name]" mode="name" />
    <xsl:apply-templates select="//mis:hidden[@name]"  mode="name" />
    <xsl:apply-templates select="//mis:textarea[@name]" mode="name"/>
    <xsl:apply-templates select="//mis:button[@name]" mode="name"/>
    <xsl:apply-templates select="//mis:directWriteTable[@name]" mode="name"/>
    <xsl:apply-templates select="//mis:entryQuery[@names]" mode="names" />
    <xsl:apply-templates select="//mis:plsqlUpdate[@names]" mode="names"/>
    <xsl:apply-templates select="//mis:tableExist[@names]" mode="names"/>
    <xsl:apply-templates select="//mis:tableUpdateParam[@names]" mode="names"/>
    <xsl:apply-templates select="//mis:update[@names]" mode="names"/>
    <xsl:apply-templates select="//mis:message[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//mis:button[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//mis:backGamen[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//mis:favoriteLink[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//mis:fieldset[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//mis:link[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//mis:option[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//mis:popup[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//mis:requestValue[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//mis:submit[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//mis:tab[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//mis:help[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//mis:input[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//mis:queryButton[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//mis:textArea[@lbl]" mode="lbl"/>
    <xsl:apply-templates select="//mis:columnEditor[@label]" mode="label"/>
    <xsl:apply-templates select="//mis:option[@label]" mode="label"/>
    <xsl:apply-templates select="//mis:input[@lbls]" mode="lbls"/>
    <xsl:apply-templates select="//mis:orderBy[@lbls]" mode="lbls"/>
    <xsl:apply-templates select="//mis:option[@lbls]" mode="lbls"/>
    <xsl:apply-templates select="//text()|//@*" mode="atr"/>
  </xsl:template>
  
  <xsl:template match="*|@*" mode="atr">
    	 <xsl:if test="contains(current(),'{@LBL.')">
     	<xsl:call-template name="atmarklbl">
          <xsl:with-param name="crnt" select="current()"/>
        </xsl:call-template>
   	 </xsl:if>
 	 </xsl:template>
  
  <xsl:template name="atmarklbl">
      <xsl:param name="crnt" select="1"/>
      <xsl:if test="contains($crnt,'{@LBL.')">
        <ROW>
        <xsl:copy-of select="$row_header" />
        <TAGNAME     ><xsl:value-of select="name()"  /></TAGNAME>
        <NAME><xsl:value-of select="substring-before(substring-after($crnt,'{@LBL.'),'}')"       /></NAME>
          <KBRSC		>1</KBRSC>
        </ROW>
        <xsl:call-template name="atmarklbl">
          <xsl:with-param name="crnt" select="substring-after($crnt,'{@LBL.')"/>
        </xsl:call-template>
      </xsl:if>
  </xsl:template>
  
    <xsl:template match="mis:*[@lbl]" mode="lbl">
     <xsl:if test="@lbl = translate( @lbl,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' )">
         <ROW>
           <xsl:copy-of select="$row_header" />
           <TAGNAME     ><xsl:value-of select="name()"  /></TAGNAME>
           <NAME        ><xsl:value-of select="@lbl"      /></NAME>
           <KBRSC		>1</KBRSC>
         </ROW>
    </xsl:if>
  </xsl:template>
  
  
  
  <xsl:template name="dvstr">
      <xsl:param name="count" select="1"/>
      <xsl:if test="contains($count,',')">
        <ROW>
        <xsl:copy-of select="$row_header" />
        <TAGNAME     ><xsl:value-of select="name()"  /></TAGNAME>
        <NAME><xsl:value-of select="substring-before($count,',')"       /></NAME>
          <KBRSC		>1</KBRSC>
        </ROW>
        <xsl:call-template name="dvstr">
          <xsl:with-param name="count" select="substring-after($count,',')"/>
        </xsl:call-template>
      </xsl:if>
  </xsl:template>
  
   <xsl:template name="dvstr0">
      <xsl:param name="count" select="1"/>
      <xsl:if test="contains($count,',')">
        <ROW>
        <xsl:copy-of select="$row_header" />
        <TAGNAME     ><xsl:value-of select="name()"  /></TAGNAME>
        <NAME><xsl:value-of select="substring-before($count,',')"       /></NAME>
          <KBRSC		>0</KBRSC>
        </ROW>
        <xsl:call-template name="dvstr">
          <xsl:with-param name="count" select="substring-after($count,',')"/>
        </xsl:call-template>
      </xsl:if>
  </xsl:template>
  
  <xsl:template match="mis:*[@lbls]" mode="lbls">
     <xsl:if test="@lbls = translate( @lbls,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' )">
     <xsl:call-template name="dvstr">
          <xsl:with-param name="count" select="concat(@lbls,',')"/>
        </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="mis:*[@column]" mode="column">
     <xsl:if test="@lbl = translate( @lbl,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' )">
         <ROW>
           <xsl:copy-of select="$row_header" />
           <TAGNAME     ><xsl:value-of select="name()"  /></TAGNAME>
           <NAME        ><xsl:value-of select="@column"      /></NAME>
           <KBRSC		>1</KBRSC>
         </ROW>
    </xsl:if>
  </xsl:template>
  

  <xsl:template match="mis:*[@name]" mode="name">
     <xsl:if test="@name = translate( @name,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' )">
		         <ROW>
		           <xsl:copy-of select="$row_header" />
		           <TAGNAME     ><xsl:value-of select="name()"  /></TAGNAME>
		           <NAME        ><xsl:value-of select="@name"      /></NAME>
           <KBRSC		>0</KBRSC>
         </ROW>
         	<xsl:if test="@lbl">
         		<ROW>
         		<xsl:copy-of select="$row_header" />
		           <TAGNAME     ><xsl:value-of select="name()"  /></TAGNAME>
		           <NAME        ><xsl:value-of select="@lbl"      /></NAME>
            <KBRSC		>1</KBRSC>
         		</ROW>
         	</xsl:if>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="mis:*[@names]" mode="names">
     <xsl:if test="@names = translate( @names,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' )">
     <xsl:call-template name="dvstr0">
          <xsl:with-param name="count" select="concat(@names,',')"/>
        </xsl:call-template>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="mis:*[@columns]" mode="columns">
     <xsl:if test="@columns = translate( @columns,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ' )">
     <xsl:call-template name="dvstr0">
          <xsl:with-param name="count" select="concat(@columns,',')"/>
        </xsl:call-template>
    </xsl:if>
  </xsl:template>


</xsl:stylesheet>
