<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:fn="http://java.sun.com/jsp/jstl/functions"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true">
<og:equals val1="{@COLUMN_NAME2}" nullCheck="true" notEquals="true">
<og:text>
	<script type="text/javascript">
		// 線形単回帰の実行
		function simpleRegression(piInput){
			var slope = parseFloat($('#slope').text());
			var intercept = parseFloat($('#intercept').text());
			return piInput  * slope + intercept;
			
		}
		
		// 2次回帰の実行
		function squadraticRegression(piInput){
			var c1 = parseFloat($('#c1').text());
			var c2 = parseFloat($('#c2').text());
			var c3 = parseFloat($('#c3').text());
			
			return piInput * piInput * c1 + piInput * c2 + c3;
		}
		
		// 予測計算の実行
		function btnPredict(){
			var methodCalc = $('#METHOD_CALC').val();
			console.log(methodCalc);
			
			var input = parseFloat($('input[name=COLUMN_NAME1]').val());
			var result;
			if(methodCalc == '1'){
				result = simpleRegression(input);
			}else{
				result = squadraticRegression(input);
			}
			$('#result').text("{@LBL.${param.COLUMN_NAME2}}：" + result);
		}
	</script>
</og:text>
</og:equals>
</og:head>

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= ""
	title	= "DB単回帰"
	date	= "2017/04/07"
	author	= "T.OTA"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<!-- ﾚｺｰﾄﾞが2件以上登録されているかのﾁｪｯｸ -->
<og:dataCheck
	command			= "NEW"
	lbl				= "ERR0047"
	lblParamKeys	= "2"
	exist     		= "true">
	select DECODE(count(*),1,0,count(*))
	from {@TABLE_NAME}
</og:dataCheck>

<!-- ﾃｰﾌﾞﾙﾃﾞｰﾀを取得 -->
<og:query command="NEW" debug="{@debug}" maxRowCount="0">
	select {@COLUMN_NAME1},{@COLUMN_NAME2}
	from {@TABLE_NAME}
	order by 1
</og:query>

<!-- 単回帰計算結果の出力 -->
<og:bizLogic logics="gf.GFX029A" keys="COLUMN_NAME1,COLUMN_NAME2,METHOD_CALC" vals="{@COLUMN_NAME1},{@COLUMN_NAME2},{@METHOD_CALC}" selectedAll="true" />
<og:text>{@RETURN}</og:text>

<!-- 回帰直線用の計算式を取得 -->
<og:bizLogic logics="gf.GFX029B" keys="COLUMN_NAME1,COLUMN_NAME2,METHOD_CALC" vals="{@COLUMN_NAME1},{@COLUMN_NAME2},{@METHOD_CALC}" selectedAll="true" />

<og:query command="NEW" debug="{@debug}" maxRowCount="0">
	select {@COLUMN_NAME1},{@COLUMN_NAME2},{@RETURN} KAIKI
	from {@TABLE_NAME}
	where {@COLUMN_NAME1} is not NULL
	and {@COLUMN_NAME2} is not NULL
	order by 1
</og:query>

<!-- グラフ出力 -->
<og:jsChart chartType="line"
	labelColumn="{@COLUMN_NAME1}"
	xscaleType = "linear"
	xlabel		= "{@COLUMN_NAME1}"
	ylabel		= "{@COLUMN_NAME2}">
 	<!-- 散布図 -->
 	<og:jsChartData
 		chartColumn = "{@COLUMN_NAME2}"
 		label		= "{@COLUMN_NAME2}"
 		borderColor = "rgba(0,0,0,0)"
 		backgroundColor = "rgb(0,0,0)"
 		 />
 	<!-- 回帰直線 -->
 	<og:jsChartData
 		chartColumn = "KAIKI"
 		label		= "KAIKI"
 		borderColor = "rgb(0,0,255)"
 		backgroundColor = "rgb(0,0,255)"
 		 />
 </og:jsChart><br />

<!-- ﾃｰﾌﾞﾙﾃﾞｰﾀの出力 -->
<!-- <og:view height="200px" /><br /> -->

<!-- 予測計算 -->
<og:input name="COLUMN_NAME1" lbl="{@COLUMN_NAME1}" />
<og:button type="button" onClick="btnPredict();"><og:text>{@LBL.MSG0086}</og:text></og:button>
<span id="result"><!--  --></span>

<og:hidden keys="METHOD_CALC" vals="{@METHOD_CALC}" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
