<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page import="org.opengion.hayabusa.common.HybsSystem" />
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<jsp:directive.page isErrorPage = "true" />

<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta http-equiv="Content-Style-Type" content="text/css" />

<jsp:scriptlet>
	int statusCode = pageContext.getErrorData().getStatusCode();
	if( statusCode != 401 ) {
		String jsp = HybsSystem.sys( "JSP" );
		out.println("&lt;link rel='stylesheet' href='" + jsp + "/common/default.css' type='text/css' /&gt;");
		out.println("&lt;link rel='stylesheet' href='" + jsp + "/custom/custom.css'  type='text/css' /&gt;");
		// 5.7.8.1 (2014/07/11) 追加
		out.println("&lt;script type='text/javascript' src='" + jsp + "/common/jquery/jquery.js' &gt; &lt;/script&gt;");
	}
	String title = (String)session.getAttribute( "GUI_TITLE" );
	if( title == null ) { title = "Application Error"; }
	out.println("&lt;title&gt;" + title + "&lt;/title&gt;");
</jsp:scriptlet>

	<style type="text/css">
		#time{ text-align:right; color: #ee7777; }
		#msg{ text-align:center; }
	</style>

	<script type="text/javascript" >
		$(function(){
			var qfrm=window.parent.frames['QUERY'];
			if(qfrm){ $(document).ready(function(){ qfrm.$.fnUnblockUI(); }); }
		});
	</script>

</head>
<body>

<jsp:scriptlet>
	String errDispLvl = HybsSystem.sys( "ERR_DISP_LEVEL" );

	// 401の場合はコードを送る必要がある
	if( statusCode == 401 ){
		response.addHeader("WWW-Authenticate", "BASIC realm=\"Web App\"");
		response.setStatus(401);
		pageContext.include( "/jsp/common/error_Auth.jsp", false );
	}
	else if( statusCode == 403 || statusCode ==404 ){
		pageContext.include( "/jsp/common/error_Forbidden.jsp", false );
	}
	else if( "1".equals( errDispLvl ) ) {
		pageContext.include( "/jsp/common/error_1.jsp", false );
	}
	else if( "2".equals( errDispLvl ) ) {
		pageContext.include( "/jsp/common/error_2.jsp", false );
	}
	else {
		pageContext.include( "/jsp/common/error_0.jsp", false );
	}
</jsp:scriptlet>

</body>
</html>

</jsp:root>
