/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.telemetry.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.openstack4j.model.common.builder.BasicResourceBuilder;
import org.openstack4j.model.telemetry.Alarm;
import org.openstack4j.model.telemetry.builder.AlarmBuilder;

public class CeilometerAlarm
implements Alarm {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="project_id")
    private String projectId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    private Alarm.Type type;
    @JsonProperty(value="user_id")
    private String userId;
    @JsonProperty(value="alarm_actions")
    private List<String> alarmActions;
    @JsonProperty(value="alarm_id")
    private String alarmId;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="enabled")
    private boolean isEnabled;
    @JsonProperty(value="insufficient_data_actions")
    private List<String> insufficientDataActions;
    @JsonProperty(value="ok_actions")
    private List<String> okActions;
    @JsonProperty(value="repeat_actions")
    private boolean repeatActions;
    @JsonProperty(value="state")
    private String state;
    @JsonProperty(value="state_timestamp")
    private String stateTimestamp;
    @JsonProperty(value="threshold_rule")
    private CeilometerThresholdRule thresholdRule;
    @JsonProperty(value="combination_rule")
    private CeilometerCombinationRule combinationRule;
    @JsonProperty(value="timestamp")
    private String timestamp;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public Alarm.Type getType() {
        return this.type;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.alarmId).add("name", (Object)this.name).add("enabled", this.isEnabled).add("project_id", (Object)this.projectId).add("type", (Object)this.type).add("user_id", (Object)this.userId).toString();
    }

    @Override
    public List<String> getAlarmActions() {
        return this.alarmActions;
    }

    @Override
    public String getAlarmId() {
        return this.alarmId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void isEnabled(boolean newValue) {
        this.isEnabled = newValue;
    }

    @Override
    public List<String> getInsufficientDataActions() {
        return this.insufficientDataActions;
    }

    @Override
    public List<String> getOkActions() {
        return this.okActions;
    }

    @Override
    public boolean getRepeatActions() {
        return this.repeatActions;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public String getStateTimestamp() {
        return this.stateTimestamp;
    }

    @Override
    public Alarm.ThresholdRule getThresholdRule() {
        return this.thresholdRule;
    }

    @Override
    public Alarm.CombinationRule getCombinationRule() {
        return this.combinationRule;
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    public static AlarmBuilder builder() {
        return new AlarmConcreteBuilder();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setType(Alarm.Type type) {
        this.type = type;
    }

    @Override
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public void setAlarmActions(List<String> alarmActions) {
        this.alarmActions = alarmActions;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setInsufficientDataActions(List<String> insufficientDataActions) {
        this.insufficientDataActions = insufficientDataActions;
    }

    @Override
    public void setOkActions(List<String> okActions) {
        this.okActions = okActions;
    }

    @Override
    public void setRepeateActions(Boolean repeatActions) {
        this.repeatActions = repeatActions;
    }

    @Override
    public String getId() {
        return this.alarmId;
    }

    @Override
    public void setId(String id) {
        this.alarmId = id;
    }

    @Override
    public void setThresholdRule(CeilometerThresholdRule tr) {
        this.thresholdRule = tr;
    }

    @Override
    public AlarmBuilder toBuilder() {
        return new AlarmConcreteBuilder(this);
    }

    public static class AlarmConcreteBuilder
    extends BasicResourceBuilder<Alarm, AlarmConcreteBuilder>
    implements AlarmBuilder {
        private CeilometerAlarm m;

        AlarmConcreteBuilder() {
            this(new CeilometerAlarm());
        }

        AlarmConcreteBuilder(CeilometerAlarm m) {
            this.m = m;
        }

        @Override
        public Alarm build() {
            return this.m;
        }

        @Override
        public AlarmBuilder from(Alarm in) {
            this.m = (CeilometerAlarm)in;
            return this;
        }

        @Override
        public AlarmBuilder okActions(List<String> okActions) {
            this.m.okActions = okActions;
            return this;
        }

        @Override
        protected Alarm reference() {
            return this.m;
        }

        @Override
        public AlarmBuilder type(Alarm.Type type) {
            this.m.type = type;
            return this;
        }

        @Override
        public AlarmBuilder thresholeRule(CeilometerThresholdRule tr) {
            this.m.thresholdRule = tr;
            return this;
        }

        @Override
        public AlarmBuilder repeatActions(boolean repeatActions) {
            this.m.repeatActions = repeatActions;
            return this;
        }

        @Override
        public AlarmBuilder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public AlarmBuilder alarmActions(List<String> alarmActions) {
            this.m.alarmActions = alarmActions;
            return this;
        }

        @Override
        public AlarmBuilder isEnabled(boolean isEnabled) {
            this.m.isEnabled = isEnabled;
            return this;
        }

        @Override
        public AlarmBuilder combinationRule(CeilometerCombinationRule ce) {
            this.m.combinationRule = ce;
            return this;
        }
    }

    public static class CeilometerQuery
    implements Alarm.ThresholdRule.Query {
        @JsonProperty(value="field")
        String field;
        @JsonProperty(value="value")
        String value;
        @JsonProperty(value="op")
        Alarm.ThresholdRule.ComparisonOperator op;

        @Override
        public String getField() {
            return this.field;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public Alarm.ThresholdRule.ComparisonOperator getOp() {
            return this.op;
        }

        @Override
        public void setField(String field) {
            this.field = field;
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public void setOp(Alarm.ThresholdRule.ComparisonOperator comparisonOperator) {
            this.op = comparisonOperator;
        }
    }

    public static class CeilometerThresholdRule
    implements Alarm.ThresholdRule {
        @JsonProperty(value="meter_name")
        String meterName;
        @JsonProperty(value="evaluation_periods")
        int evaluationPeriods;
        @JsonProperty(value="statistic")
        Alarm.ThresholdRule.Statistic statistic;
        @JsonProperty(value="period")
        int period;
        @JsonProperty(value="threshold")
        float threshold;
        @JsonProperty(value="query")
        List<CeilometerQuery> query;
        @JsonProperty(value="comparison_operator")
        Alarm.ThresholdRule.ComparisonOperator comparisonOperator;
        @JsonProperty(value="exclude_outliers")
        boolean excludeOutliers;

        @Override
        public String getMeterName() {
            return this.meterName;
        }

        @Override
        public int getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public Alarm.ThresholdRule.Statistic getStatistic() {
            return this.statistic;
        }

        @Override
        public int getPeriod() {
            return this.period;
        }

        @Override
        public float getThreshold() {
            return this.threshold;
        }

        @Override
        public List<? extends Alarm.ThresholdRule.Query> getQuery() {
            return this.query;
        }

        @Override
        public Alarm.ThresholdRule.ComparisonOperator getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public boolean getExcludeOutliers() {
            return this.excludeOutliers;
        }

        @Override
        public void setMeterName(String meterName) {
            this.meterName = meterName;
        }

        @Override
        public void setEvaluationPeriods(int evaluationPeriod) {
            this.evaluationPeriods = evaluationPeriod;
        }

        @Override
        public void setStatistic(Alarm.ThresholdRule.Statistic statistic) {
            this.statistic = statistic;
        }

        @Override
        public void setPeriod(int period) {
            this.period = period;
        }

        @Override
        public void setThreshold(float threshold) {
            this.threshold = threshold;
        }

        @Override
        public void setQuery(List<CeilometerQuery> query) {
            this.query = query;
        }

        @Override
        public void setComparisonOperator(Alarm.ThresholdRule.ComparisonOperator comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public void setExcludeOutliers(boolean excludeOutliers) {
            this.excludeOutliers = excludeOutliers;
        }
    }

    public static class CeilometerCombinationRule
    implements Alarm.CombinationRule {
        @JsonProperty(value="alarm_ids")
        List<String> alarmIds;
        @JsonProperty(value="operator")
        Alarm.CombinationRule.Operator operator;

        @Override
        public List<String> getAlarmIds() {
            return this.alarmIds;
        }

        @Override
        public Alarm.CombinationRule.Operator getOperator() {
            return this.operator;
        }

        @Override
        public void setAlarmIds(List<String> alarmIds) {
            this.alarmIds = alarmIds;
        }

        @Override
        public void setOperator(Alarm.CombinationRule.Operator operator) {
            this.operator = operator;
        }
    }
}

