/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.octavia.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.openstack4j.model.octavia.LbOperatingStatus;
import org.openstack4j.model.octavia.LbProvisioningStatus;
import org.openstack4j.model.octavia.LoadBalancerV2;
import org.openstack4j.model.octavia.builder.LoadBalancerV2Builder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.octavia.domain.ListItem;

@JsonRootName(value="loadbalancer")
@JsonIgnoreProperties(ignoreUnknown=true)
public class OctaviaLoadBalancerV2
implements LoadBalancerV2 {
    private String id;
    @JsonProperty(value="project_id")
    private String projectId;
    private String name;
    private String description;
    @JsonProperty(value="vip_subnet_id")
    private String vipSubnetId;
    @JsonProperty(value="vip_address")
    private String vipAddress;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp = true;
    @JsonProperty(value="provisioning_status")
    private LbProvisioningStatus provisioningStatus;
    @JsonProperty(value="operating_status")
    private LbOperatingStatus operatingStatus;
    private List<ListItem> listeners;
    @JsonProperty(value="vip_port_id")
    private String vipPortId;
    private String provider;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="vip_subnet_id")
    public String getVipSubnetId() {
        return this.vipSubnetId;
    }

    @Override
    public String getVipAddress() {
        return this.vipAddress;
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public List<ListItem> getListeners() {
        return this.listeners;
    }

    @Override
    public LbProvisioningStatus getProvisioningStatus() {
        return this.provisioningStatus;
    }

    @Override
    public LbOperatingStatus getOperatingStatus() {
        return this.operatingStatus;
    }

    @Override
    public String getVipPortId() {
        return this.vipPortId;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public LoadBalancerV2Builder toBuilder() {
        return new LoadBalancerV2ConcreteBuilder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("projectId", (Object)this.projectId).add("name", (Object)this.name).add("description", (Object)this.description).add("vipSubnetId", (Object)this.vipSubnetId).add("vipAddress", (Object)this.vipAddress).add("adminStateUp", this.adminStateUp).add("provisioningStatus", (Object)this.provisioningStatus).add("operatingStatus", (Object)this.operatingStatus).add("listeners", this.listeners).add("vipPortId", (Object)this.vipPortId).add("provider", (Object)this.provider).toString();
    }

    public static LoadBalancerV2Builder builder() {
        return new LoadBalancerV2ConcreteBuilder();
    }

    public static class LoadBalancerV2ConcreteBuilder
    implements LoadBalancerV2Builder {
        private OctaviaLoadBalancerV2 m;

        public LoadBalancerV2ConcreteBuilder() {
            this(new OctaviaLoadBalancerV2());
        }

        public LoadBalancerV2ConcreteBuilder(OctaviaLoadBalancerV2 m) {
            this.m = m;
        }

        @Override
        public LoadBalancerV2 build() {
            return this.m;
        }

        @Override
        public LoadBalancerV2Builder from(LoadBalancerV2 in) {
            this.m = (OctaviaLoadBalancerV2)in;
            return this;
        }

        @Override
        public LoadBalancerV2Builder projectId(String projectId) {
            this.m.projectId = projectId;
            return this;
        }

        @Override
        public LoadBalancerV2Builder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public LoadBalancerV2Builder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public LoadBalancerV2Builder subnetId(String vipSubnetId) {
            this.m.vipSubnetId = vipSubnetId;
            return this;
        }

        @Override
        public LoadBalancerV2Builder address(String vipAddress) {
            this.m.vipAddress = vipAddress;
            return this;
        }

        @Override
        public LoadBalancerV2Builder adminStateUp(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }

        @Override
        public LoadBalancerV2Builder provider(String provider) {
            this.m.provider = provider;
            return this;
        }
    }

    public static class LoadBalancersV2
    extends ListResult<OctaviaLoadBalancerV2> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="loadbalancers")
        List<OctaviaLoadBalancerV2> loadbalancers;

        @Override
        public List<OctaviaLoadBalancerV2> value() {
            return this.loadbalancers;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("loadbalancers", this.loadbalancers).toString();
        }
    }
}

