/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.gbp.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.openstack4j.model.gbp.IPVersionType;
import org.openstack4j.model.gbp.NatPool;
import org.openstack4j.model.gbp.builder.NatPoolBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="nat_pool")
public class GbpNatPool
implements NatPool {
    private static final long serialVersionUID = 1L;
    private String name;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String id;
    private String description;
    private Boolean shared;
    @JsonProperty(value="external_segment_id")
    private String externalSegmentId;
    @JsonProperty(value="ip_pool")
    private String ipPool;
    @JsonProperty(value="ip_version")
    private String ipVersion;
    @JsonProperty(value="subnet_id")
    private String subnetId;

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isShared() {
        return this.shared == null ? false : this.shared;
    }

    @Override
    public String getExternalSegmentId() {
        return this.externalSegmentId;
    }

    @Override
    public String getIpPool() {
        return this.ipPool;
    }

    @Override
    public String getIpVersion() {
        return this.ipVersion;
    }

    @Override
    public String getSubnetId() {
        return this.subnetId;
    }

    @Override
    public NatPoolBuilder toBuilder() {
        return new NatPoolConcreteBuilder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("desription", (Object)this.description).add("tenantId", (Object)this.tenantId).add("externalSegmentId", (Object)this.externalSegmentId).add("ipPool", (Object)this.ipPool).add("ipVersion", (Object)this.ipVersion).add("subnetId", (Object)this.subnetId).add("shared", (Object)this.shared).toString();
    }

    public static NatPoolBuilder builder() {
        return new NatPoolConcreteBuilder();
    }

    public static class NatPoolConcreteBuilder
    implements NatPoolBuilder {
        private GbpNatPool natPool;

        public NatPoolConcreteBuilder(GbpNatPool gbpNatPool) {
            this.natPool = gbpNatPool;
        }

        public NatPoolConcreteBuilder() {
            this(new GbpNatPool());
        }

        @Override
        public NatPool build() {
            return this.natPool;
        }

        @Override
        public NatPoolBuilder from(NatPool in) {
            this.natPool = (GbpNatPool)in;
            return this;
        }

        @Override
        public NatPoolBuilder name(String name) {
            this.natPool.name = name;
            return this;
        }

        @Override
        public NatPoolBuilder description(String description) {
            this.natPool.description = description;
            return this;
        }

        @Override
        public NatPoolBuilder ipVersion(IPVersionType ipVersion) {
            this.natPool.ipVersion = ipVersion.name();
            return this;
        }

        @Override
        public NatPoolBuilder cidr(String cidr) {
            this.natPool.ipPool = cidr;
            return this;
        }

        @Override
        public NatPoolBuilder isShared(boolean shared) {
            this.natPool.shared = shared;
            return this;
        }

        @Override
        public NatPoolBuilder externalSegmentId(String id) {
            this.natPool.externalSegmentId = id;
            return this;
        }
    }

    public static class NatPools
    extends ListResult<GbpNatPool> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="nat_pools")
        private List<GbpNatPool> natpools;

        @Override
        protected List<GbpNatPool> value() {
            return this.natpools;
        }
    }
}

