/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.queue;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.opengion.fukurou.queue.QueueInfo;
import org.opengion.fukurou.queue.QueueSend;

public class QueueSend_MQ
implements QueueSend {
    private Connection connection = null;
    private Session session = null;
    private MessageProducer sender = null;
    private Context ctx = null;
    private boolean batch = false;
    private String mqUserId = "";
    private String mqPassword = "";

    public void connect(String string) {
        try {
            this.ctx = new InitialContext();
            ActiveMQConnectionFactory activeMQConnectionFactory = null;
            if (this.batch) {
                this.mqUserId = System.getProperty("mqUserId");
                this.mqPassword = System.getProperty("mqPassword");
                activeMQConnectionFactory = new ActiveMQConnectionFactory(string);
                this.connection = (ActiveMQConnection)activeMQConnectionFactory.createConnection(this.mqUserId, this.mqPassword);
            } else {
                activeMQConnectionFactory = (QueueConnectionFactory)this.ctx.lookup("java:comp/env/" + string);
                this.connection = (ActiveMQConnection)activeMQConnectionFactory.createConnection();
            }
            this.connection.start();
        }
        catch (JMSException jMSException) {
            this.throwErrMsg("MQ\u30b5\u30fc\u30d0\u30fc\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + jMSException.getMessage());
        }
        catch (NamingException namingException) {
            this.throwErrMsg("\u540d\u524d\u89e3\u6c7a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + namingException.getMessage());
        }
    }

    @Override
    public void connect(String string, String string2, String string3) {
        this.connect(string);
    }

    public void throwErrMsg(String string) {
        throw new RuntimeException(string);
    }

    @Override
    public void sendMessage(QueueInfo queueInfo) {
        try {
            if (this.connection == null) {
                this.throwErrMsg("MQ\u30b5\u30fc\u30d0\u306b\u63a5\u7d9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            }
            this.session = this.connection.createSession(queueInfo.isMqTransacted().booleanValue(), queueInfo.getMqAcknowledgeMode());
            if (this.session == null) {
                this.throwErrMsg("\u30ad\u30e5\u30fc\u30bb\u30c3\u30b7\u30e7\u30f3\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
            Queue queue = null;
            queue = this.session.createQueue(queueInfo.getMqQueueName());
            this.sender = this.session.createProducer((Destination)queue);
            TextMessage textMessage = this.session.createTextMessage(queueInfo.getMessage());
            this.sender.send((Message)textMessage);
        }
        catch (JMSException jMSException) {
            this.throwErrMsg("\u30ad\u30e5\u30fc\u306e\u9001\u4fe1\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + jMSException.getMessage());
        }
    }

    @Override
    public void close() {
        if (this.ctx != null) {
            try {
                this.ctx.close();
            }
            catch (Exception exception) {
                System.out.println("ctx\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
        }
        if (this.sender != null) {
            try {
                this.sender.close();
            }
            catch (Exception exception) {
                System.out.println("sender\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
        }
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (Exception exception) {
                System.out.println("session\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                System.out.println("connection\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            }
        }
    }

    @Override
    public void setBatchFlg(Boolean bl) {
        this.batch = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        System.out.println("main start");
        String string = "tcp://localhost:61616";
        String string2 = "test01";
        String string3 = "\u9001\u4fe1\u30e1\u30c3\u30bb\u30fc\u30b8";
        QueueInfo queueInfo = new QueueInfo();
        queueInfo.setMqQueueName(string2);
        queueInfo.setMqTransacted(false);
        queueInfo.setMqAcknowledgeMode(1);
        queueInfo.setMessage(string3);
        queueSend_MQ.setBatchFlg(true);
        try (QueueSend_MQ queueSend_MQ = new QueueSend_MQ();){
            queueSend_MQ.connect(string, null, null);
            queueSend_MQ.sendMessage(queueInfo);
        }
        System.out.println("main end");
    }
}

