/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.aspera.transfer;

import com.ibm.aspera.faspmanager2.faspmanager2;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AsperaLibraryLoader {
    protected static Log log = LogFactory.getLog(AsperaLibraryLoader.class);
    private static final List<String> MAC_DYNAMIC_LIBS = Collections.unmodifiableList(Arrays.asList("libfaspmanager2.jnilib", "_faspmanager2.so"));
    private static final List<String> UNIX_DYNAMIC_LIBS = Collections.unmodifiableList(Arrays.asList("libfaspmanager2.so"));
    private static final List<String> WINDOWS_DYNAMIC_LIBS = Collections.unmodifiableList(Arrays.asList("faspmanager2.dll"));
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static final File EXTRACT_LOCATION_ROOT = new File(System.getProperty("user.home") + SEPARATOR + ".aspera" + SEPARATOR + "cos-aspera");

    public static String load() {
        JarFile jar = null;
        String location = null;
        try {
            jar = AsperaLibraryLoader.createJar();
            String version = AsperaLibraryLoader.jarVersion(jar);
            location = EXTRACT_LOCATION_ROOT + SEPARATOR + version;
            File extractedLocation = new File(location);
            if (!extractedLocation.exists()) {
                AsperaLibraryLoader.extractJar(jar, extractedLocation);
            }
            AsperaLibraryLoader.loadLibrary(extractedLocation, AsperaLibraryLoader.osLibs());
        }
        catch (Exception e) {
            throw new AsperaLibraryLoadException("Unable to load Aspera Library", e);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {
                    log.warn((Object)"Unable to close Aspera jar file after loading", (Throwable)e);
                }
            }
        }
        return location;
    }

    public static JarFile createJar() throws IOException, URISyntaxException {
        URL location = faspmanager2.class.getProtectionDomain().getCodeSource().getLocation();
        return new JarFile(new File(location.toURI()));
    }

    public static String jarVersion(JarFile jar) throws IOException {
        String version = jar.getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        if (version == null) {
            version = String.format("%d", System.currentTimeMillis());
        }
        return version;
    }

    public static void extractJar(JarFile jar, File extractedLocation) throws IOException {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            File destPath = new File(extractedLocation, SEPARATOR + entry.getName());
            if (entry.isDirectory()) {
                log.debug((Object)("Creating directory: " + destPath));
                destPath.mkdirs();
                continue;
            }
            log.debug((Object)("Creating parent directories for file: " + destPath));
            destPath.getParentFile().mkdirs();
            AsperaLibraryLoader.extractFile(jar, entry, destPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractFile(JarFile jar, JarEntry entry, File destPath) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = jar.getInputStream(entry);
            out = new FileOutputStream(destPath);
            byte[] buf = new byte[1024];
            int i = in.read(buf);
            while (i != -1) {
                out.write(buf, 0, i);
                i = in.read(buf);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        if (entry.getName().equals("ascp")) {
            destPath.setExecutable(true);
            destPath.setWritable(true);
        }
    }

    public static List<String> osLibs() {
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.indexOf("win") >= 0) {
            return WINDOWS_DYNAMIC_LIBS;
        }
        if (OS.indexOf("mac") >= 0) {
            return MAC_DYNAMIC_LIBS;
        }
        if (OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0) {
            return UNIX_DYNAMIC_LIBS;
        }
        throw new AsperaLibraryLoadException("OS is not supported for Aspera");
    }

    public static void loadLibrary(File extractedPath, List<String> candidates) {
        for (String lib : candidates) {
            File libPath = new File(extractedPath, lib);
            String absPath = libPath.getAbsolutePath();
            log.debug((Object)("Attempting to load dynamic library: " + absPath));
            try {
                System.load(absPath);
                log.info((Object)("Loaded dynamic library: " + absPath));
                return;
            }
            catch (UnsatisfiedLinkError e) {
                log.debug((Object)("Unable to load dynamic library: " + absPath), (Throwable)e);
            }
        }
        throw new RuntimeException("Failed to load Aspera dynamic library from candidates " + candidates + " at location: " + extractedPath);
    }

    public static class AsperaLibraryLoadException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public AsperaLibraryLoadException(String message) {
            super(message);
        }

        public AsperaLibraryLoadException(Throwable cause) {
            super(cause);
        }

        public AsperaLibraryLoadException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

