/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.DefaultDatatypeCoder;
import org.firebirdsql.util.FirebirdSupportInfo;

public abstract class DbMetadataMediator {
    static final DatatypeCoder datatypeCoder = DefaultDatatypeCoder.forEncodingFactory(EncodingFactory.createInstance(StandardCharsets.UTF_8));

    protected abstract FirebirdSupportInfo getFirebirdSupportInfo();

    protected abstract ResultSet performMetaDataQuery(MetadataQuery var1) throws SQLException;

    byte[] createInt(int intValue) {
        return datatypeCoder.encodeInt(intValue);
    }

    byte[] createInt(Number intValue) {
        return intValue == null ? null : this.createInt(intValue.intValue());
    }

    byte[] createShort(int shortValue) {
        return datatypeCoder.encodeShort(shortValue);
    }

    byte[] createShort(Number shortValue) {
        return shortValue == null ? null : this.createShort(shortValue.intValue());
    }

    byte[] createString(String value) {
        return value != null ? value.getBytes(StandardCharsets.UTF_8) : null;
    }

    @Deprecated
    byte[] getBytes(String value) {
        return this.createString(value);
    }

    public static class MetadataQuery {
        private final String queryText;
        private final List<String> parameters;
        private final boolean standalone;

        public MetadataQuery(String queryText, List<String> parameters) {
            this(queryText, parameters, false);
        }

        public MetadataQuery(String queryText, List<String> parameters, boolean standalone) {
            this.queryText = Objects.requireNonNull(queryText, "queryText");
            this.parameters = Objects.requireNonNull(parameters, "parameters");
            this.standalone = standalone;
        }

        public String getQueryText() {
            return this.queryText;
        }

        public List<String> getParameters() {
            return this.parameters;
        }

        public boolean isStandalone() {
            return this.standalone;
        }
    }
}

