/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import org.odftoolkit.odfdom.type.OdfDataType;

public class SafeCURIE
implements OdfDataType {
    private String mCURIE;

    public SafeCURIE(String curie) throws IllegalArgumentException {
        if (curie == null || !curie.matches("^\\[(([\\i-[:]][\\c-[:]]*)?:)?.+\\]$") || curie.length() < 3) {
            throw new IllegalArgumentException("parameter is invalidate for datatype SafeCURIE");
        }
        this.mCURIE = curie;
    }

    public String toString() {
        return this.mCURIE;
    }

    public static SafeCURIE valueOf(String stringValue) throws IllegalArgumentException {
        return new SafeCURIE(stringValue);
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && stringValue.matches("^\\[(([\\i-[:]][\\c-[:]]*)?:)?.+\\]$") && stringValue.length() >= 3;
    }
}

