/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.firebirdsql.gds.GDSExceptionHelper;

public class GDSException
extends Exception {
    private static final long serialVersionUID = -2993273656432230359L;
    private static final AtomicReferenceFieldUpdater<GDSException, GDSException> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(GDSException.class, GDSException.class, "next");
    private final int type;
    private final int intParam;
    private final String strParam;
    private int xaErrorCode;
    private volatile GDSException next;

    public static GDSException createWithXAErrorCode(String message, int xaErrorCode) {
        GDSException gdse = new GDSException(message);
        gdse.setXAErrorCode(xaErrorCode);
        return gdse;
    }

    public GDSException(int type, int intParam) {
        this.type = type;
        this.intParam = intParam;
        this.strParam = null;
    }

    public GDSException(int type, String strParam) {
        this.type = type;
        this.strParam = strParam;
        this.intParam = 0;
    }

    public GDSException(int type, int fbErrorCode, String strParam) {
        this.type = type;
        this.intParam = fbErrorCode;
        this.strParam = null;
        this.setNext(new GDSException(2, strParam));
    }

    public GDSException(int type, int fbErrorCode, String strParam, Throwable cause) {
        this(type, fbErrorCode, strParam);
        this.initCause(cause);
        this.setNext(new GDSException(2, strParam));
    }

    public GDSException(int fbErrorCode) {
        this.intParam = fbErrorCode;
        this.type = 1;
        this.strParam = null;
    }

    public GDSException(int fbErrorCode, Throwable cause) {
        this(fbErrorCode);
        this.initCause(cause);
    }

    public GDSException(String message) {
        super(message);
        this.type = 2;
        this.intParam = 0;
        this.strParam = null;
    }

    public int getFbErrorCode() {
        switch (this.type) {
            case 1: 
            case 4: 
            case 18: {
                return this.intParam;
            }
        }
        return -1;
    }

    public String getSQLState() {
        switch (this.type) {
            case 1: 
            case 4: {
                return GDSExceptionHelper.getSQLState(this.intParam);
            }
        }
        return null;
    }

    public int getIntParam() {
        return this.intParam;
    }

    public int getXAErrorCode() {
        return this.xaErrorCode;
    }

    public void setXAErrorCode(int xaErrorCode) {
        this.xaErrorCode = xaErrorCode;
    }

    public void setNext(GDSException e) {
        GDSException current = this;
        while (true) {
            GDSException next;
            if ((next = current.next) != null) {
                current = next;
                continue;
            }
            if (nextUpdater.compareAndSet(current, null, e)) {
                return;
            }
            current = current.next;
        }
    }

    public GDSException getNext() {
        return this.next;
    }

    public boolean isWarning() {
        return this.type == 18;
    }

    @Override
    public String getMessage() {
        Object msg;
        GDSException child = this.next;
        if (this.type == 1 || this.type == 18) {
            GDSExceptionHelper.GDSMessage message = GDSExceptionHelper.getMessage(this.intParam);
            int paramCount = message.getParamCount();
            for (int i = 0; i < paramCount && child != null; ++i) {
                message.setParameter(i, child.getParam());
                child = child.next;
            }
            msg = message.toString();
        } else {
            msg = super.getMessage();
        }
        if (child != null) {
            msg = (String)msg + "\n" + child.getMessage();
        }
        return msg;
    }

    public String getParam() {
        switch (this.type) {
            case 2: 
            case 5: {
                return this.strParam;
            }
            case 4: {
                return String.valueOf(this.intParam);
            }
        }
        return "";
    }
}

