/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public final class ProtocolCollection
implements Iterable<ProtocolDescriptor> {
    private static final Logger log = LoggerFactory.getLogger(ProtocolCollection.class);
    private final Map<Integer, ProtocolDescriptor> descriptorMap;
    private static final ProtocolCollection DEFAULT_COLLECTION;

    private static List<ClassLoader> classLoadersForLoading() {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(2);
        ClassLoader classLoader = ProtocolDescriptor.class.getClassLoader();
        if (classLoader != null) {
            classLoaders.add(classLoader);
        } else {
            classLoaders.add(ClassLoader.getSystemClassLoader());
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null && !classLoaders.contains(contextClassLoader)) {
            classLoaders.add(contextClassLoader);
        }
        return classLoaders;
    }

    private static List<ProtocolDescriptor> loadProtocolsFallback(ClassLoader classLoader) {
        String[] protocolClasses = new String[]{"org.firebirdsql.gds.ng.wire.version10.Version10Descriptor", "org.firebirdsql.gds.ng.wire.version11.Version11Descriptor", "org.firebirdsql.gds.ng.wire.version12.Version12Descriptor", "org.firebirdsql.gds.ng.wire.version13.Version13Descriptor", "org.firebirdsql.gds.ng.wire.version15.Version15Descriptor", "org.firebirdsql.gds.ng.wire.version16.Version16Descriptor"};
        ArrayList<ProtocolDescriptor> protocols = new ArrayList<ProtocolDescriptor>(protocolClasses.length);
        for (String className : protocolClasses) {
            try {
                Class<?> clazz = classLoader.loadClass(className);
                ProtocolDescriptor protocol = (ProtocolDescriptor)clazz.newInstance();
                protocols.add(protocol);
            }
            catch (Exception e) {
                String message = String.format("Unable to load protocol %s in loadProtocolsFallback; skipping", className);
                log.warn(message + ": " + e + "; see debug level for stacktrace");
                log.debug(message, e);
            }
        }
        return protocols;
    }

    private ProtocolCollection(Map<Integer, ProtocolDescriptor> protocolDescriptors) {
        this.descriptorMap = Collections.unmodifiableMap(protocolDescriptors);
    }

    @Override
    public Iterator<ProtocolDescriptor> iterator() {
        return this.descriptorMap.values().iterator();
    }

    public ProtocolDescriptor getProtocolDescriptor(int protocolVersion) {
        return this.descriptorMap.get(protocolVersion);
    }

    public int getProtocolCount() {
        return this.descriptorMap.size();
    }

    public List<Integer> getProtocolVersions() {
        ArrayList<Integer> versions = new ArrayList<Integer>();
        for (ProtocolDescriptor descriptor : this) {
            versions.add(descriptor.getVersion());
        }
        return versions;
    }

    public static ProtocolCollection create(ProtocolDescriptor ... descriptors) {
        HashMap<Integer, ProtocolDescriptor> descriptorMap = new HashMap<Integer, ProtocolDescriptor>();
        for (ProtocolDescriptor descriptor : descriptors) {
            ProtocolDescriptor existingDescriptor = (ProtocolDescriptor)descriptorMap.get(descriptor.getVersion());
            if (existingDescriptor != null && descriptor.getWeight() <= existingDescriptor.getWeight()) continue;
            descriptorMap.put(descriptor.getVersion(), descriptor);
        }
        return new ProtocolCollection(descriptorMap);
    }

    public static ProtocolCollection getDefaultCollection() {
        return DEFAULT_COLLECTION;
    }

    static {
        HashSet<ProtocolDescriptor> supportedProtocols = new HashSet<ProtocolDescriptor>();
        List<ClassLoader> classLoaders = ProtocolCollection.classLoadersForLoading();
        for (ClassLoader classLoader : classLoaders) {
            ServiceLoader<ProtocolDescriptor> descriptors = ServiceLoader.load(ProtocolDescriptor.class, classLoader);
            Iterator<ProtocolDescriptor> descriptorIterator = descriptors.iterator();
            while (descriptorIterator.hasNext()) {
                try {
                    ProtocolDescriptor protocol = descriptorIterator.next();
                    if (supportedProtocols.contains(protocol)) continue;
                    supportedProtocols.add(protocol);
                }
                catch (Exception | ServiceConfigurationError e) {
                    String message = "Could not load protocol descriptor (skipping)";
                    log.error(message + ": " + e + "; see debug level for stacktrace");
                    log.debug(message, e);
                }
            }
        }
        if (supportedProtocols.isEmpty()) {
            for (ClassLoader classLoader : classLoaders) {
                supportedProtocols.addAll(ProtocolCollection.loadProtocolsFallback(classLoader));
            }
        }
        DEFAULT_COLLECTION = ProtocolCollection.create(supportedProtocols.toArray(new ProtocolDescriptor[0]));
    }
}

