/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.auth.srp;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.util.Arrays;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.util.ByteArrayHelper;

public final class SrpClient {
    private static final int SRP_KEY_SIZE = 128;
    private static final int SRP_SALT_SIZE = 32;
    private static final int EXPECTED_AUTH_DATA_LENGTH = 324;
    private static final BigInteger N = new BigInteger("E67D2E994B2F900C3F41F08F5BB2627ED0D49EE1FE767A52EFCD565CD6E768812C3E1E9CE8F0A8BEA6CB13CD29DDEBF7A96D4A93B55D488DF099A15C89DCB0640738EB2CBDD9A8F7BAB561AB1B0DC1C6CDABF303264A08D1BCA932D1F1EE428B619D970F342ABA9A65793B8B2F041AE5364350C16F735F56ECBCA87BD57B29E7", 16);
    private static final BigInteger g = new BigInteger("2");
    private static final BigInteger k = new BigInteger("1277432915985975349439481660349303019122249719989");
    private static final SecureRandom random = new SecureRandom();
    private static final byte SEPARATOR_BYTE = 58;
    private final MessageDigest sha1Md;
    private final String clientProofHashAlgorithm;
    private final BigInteger publicKey;
    private final BigInteger privateKey;
    private byte[] sessionKey;

    public SrpClient(String clientProofHashAlgorithm) {
        this.clientProofHashAlgorithm = clientProofHashAlgorithm;
        this.privateKey = SrpClient.getSecret();
        this.publicKey = g.modPow(this.privateKey, N);
        try {
            this.sha1Md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-1 MessageDigest not available", e);
        }
    }

    private static BigInteger fromBigByteArray(byte[] b) {
        return new BigInteger(1, b);
    }

    private static byte[] toBigByteArray(BigInteger n) {
        byte[] b = n.toByteArray();
        if (b[0] != 0) {
            return b;
        }
        int i = 1;
        while (b[i] == 0) {
            ++i;
        }
        return Arrays.copyOfRange(b, i, b.length);
    }

    private static String padHexBinary(String hexString) {
        if (hexString.length() % 2 != 0) {
            return "0" + hexString;
        }
        return hexString;
    }

    private byte[] sha1(byte[] bytes) {
        try {
            byte[] byArray = this.sha1Md.digest(bytes);
            return byArray;
        }
        finally {
            this.sha1Md.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] sha1(byte[] bytes1, byte[] bytes2) {
        try {
            this.sha1Md.update(bytes1);
            byte[] byArray = this.sha1Md.digest(bytes2);
            return byArray;
        }
        finally {
            this.sha1Md.reset();
        }
    }

    private static byte[] pad(BigInteger n) {
        byte[] bn = SrpClient.toBigByteArray(n);
        if (bn.length > 128) {
            return Arrays.copyOfRange(bn, bn.length - 128, bn.length);
        }
        return bn;
    }

    private BigInteger getScramble(BigInteger x, BigInteger y) {
        return SrpClient.fromBigByteArray(this.sha1(SrpClient.pad(x), SrpClient.pad(y)));
    }

    private static BigInteger getSecret() {
        return new BigInteger(128, random);
    }

    static byte[] getSalt() {
        byte[] b = new byte[32];
        random.nextBytes(b);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigInteger getUserHash(String user, String password, byte[] salt) {
        byte[] hash1;
        try {
            this.sha1Md.update(user.getBytes(StandardCharsets.UTF_8));
            this.sha1Md.update((byte)58);
            hash1 = this.sha1Md.digest(password.getBytes(StandardCharsets.UTF_8));
        }
        finally {
            this.sha1Md.reset();
        }
        byte[] hash2 = this.sha1(salt, hash1);
        return SrpClient.fromBigByteArray(hash2);
    }

    KeyPair serverSeed(String user, String password, byte[] salt) {
        BigInteger v = g.modPow(this.getUserHash(user, password, salt), N);
        BigInteger b = SrpClient.getSecret();
        BigInteger gb = g.modPow(b, N);
        BigInteger kv = k.multiply(v).mod(N);
        BigInteger B = kv.add(gb).mod(N);
        return new KeyPair(B, b);
    }

    byte[] getServerSessionKey(String user, String password, byte[] salt, BigInteger A, BigInteger B, BigInteger b) {
        BigInteger u = this.getScramble(A, B);
        BigInteger v = g.modPow(this.getUserHash(user, password, salt), N);
        BigInteger vu = v.modPow(u, N);
        BigInteger Avu = A.multiply(vu).mod(N);
        BigInteger sessionSecret = Avu.modPow(b, N);
        return this.sha1(SrpClient.toBigByteArray(sessionSecret));
    }

    public BigInteger getPublicKey() {
        return this.publicKey;
    }

    public BigInteger getPrivateKey() {
        return this.privateKey;
    }

    private byte[] getClientSessionKey(String user, String password, byte[] salt, BigInteger serverPublicKey) {
        BigInteger u = this.getScramble(this.publicKey, serverPublicKey);
        BigInteger x = this.getUserHash(user, password, salt);
        BigInteger gx = g.modPow(x, N);
        BigInteger kgx = k.multiply(gx).mod(N);
        BigInteger diff = serverPublicKey.subtract(kgx).mod(N);
        BigInteger ux = u.multiply(x).mod(N);
        BigInteger aux = this.privateKey.add(ux).mod(N);
        BigInteger sessionSecret = diff.modPow(aux, N);
        return this.sha1(SrpClient.toBigByteArray(sessionSecret));
    }

    String getPublicKeyHex() {
        return ByteArrayHelper.toHexString(SrpClient.pad(this.publicKey));
    }

    byte[] clientProof(String user, String password, byte[] salt, BigInteger serverPublicKey) throws SQLException {
        byte[] K = this.getClientSessionKey(user, password, salt, serverPublicKey);
        BigInteger n1 = SrpClient.fromBigByteArray(this.sha1(SrpClient.toBigByteArray(N)));
        BigInteger n2 = SrpClient.fromBigByteArray(this.sha1(SrpClient.toBigByteArray(g)));
        byte[] M = this.clientProofHash(SrpClient.toBigByteArray(n1.modPow(n2, N)), this.sha1(user.getBytes(StandardCharsets.UTF_8)), salt, SrpClient.toBigByteArray(this.publicKey), SrpClient.toBigByteArray(serverPublicKey), K);
        this.sessionKey = K;
        return M;
    }

    private byte[] clientProofHash(byte[] ... ba) throws SQLException {
        try {
            MessageDigest md = MessageDigest.getInstance(this.clientProofHashAlgorithm);
            for (byte[] b : ba) {
                md.update(b);
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw FbExceptionBuilder.forException(337248286).messageParameter(this.clientProofHashAlgorithm).cause(e).toFlatSQLException();
        }
    }

    byte[] clientProof(String user, String password, byte[] authData) throws SQLException {
        if (authData == null || authData.length == 0) {
            throw new FbExceptionBuilder().exception(335545069).toFlatSQLException();
        }
        if (authData.length > 324) {
            throw new FbExceptionBuilder().exception(335545070).messageParameter(authData.length).messageParameter(324).messageParameter("data").toFlatSQLException();
        }
        int saltLength = VaxEncoding.iscVaxInteger2(authData, 0);
        if (saltLength > 64) {
            throw new FbExceptionBuilder().exception(335545070).messageParameter(saltLength).messageParameter(64).messageParameter("salt").toFlatSQLException();
        }
        byte[] salt = Arrays.copyOfRange(authData, 2, saltLength + 2);
        int serverKeyStart = saltLength + 4;
        int keyLength = VaxEncoding.iscVaxInteger2(authData, saltLength + 2);
        if (authData.length - serverKeyStart != keyLength) {
            throw new FbExceptionBuilder().exception(335545070).messageParameter(keyLength).messageParameter(authData.length - serverKeyStart).messageParameter("key").toFlatSQLException();
        }
        String hexServerPublicKey = new String(authData, serverKeyStart, authData.length - serverKeyStart, StandardCharsets.US_ASCII);
        BigInteger serverPublicKey = new BigInteger(SrpClient.padHexBinary(hexServerPublicKey), 16);
        return this.clientProof(user, password, salt, serverPublicKey);
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    static class KeyPair {
        private BigInteger pub;
        private BigInteger secret;

        private KeyPair(BigInteger pub, BigInteger secret) {
            this.pub = pub;
            this.secret = secret;
        }

        BigInteger getPublicKey() {
            return this.pub;
        }

        BigInteger getPrivateKey() {
            return this.secret;
        }
    }
}

