/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.internal.XSPrincipal;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class XSPrincipalI
extends XSPrincipal {
    long kpxsprindbid = 0L;
    String kpxsprinname = null;
    byte[] kpxsprinnameBytes = null;
    byte[] kpxsprinuuid = null;
    XSPrincipal.Flag kpxsprinflg = XSPrincipal.Flag.KPXS_PRIN_EXT;

    XSPrincipalI() {
    }

    @Override
    public void setDatabaseId(long l2) throws SQLException {
        this.kpxsprindbid = l2;
    }

    @Override
    public void setName(String string) throws SQLException {
        this.kpxsprinname = string;
    }

    @Override
    public void setUUID(byte[] byArray) throws SQLException {
        this.kpxsprinuuid = byArray;
    }

    @Override
    public void setFlag(XSPrincipal.Flag flag) throws SQLException {
        this.kpxsprinflg = flag;
    }

    @Override
    public long getDatabaseId() {
        return this.kpxsprindbid;
    }

    @Override
    public String getName() {
        return this.kpxsprinname;
    }

    @Override
    public byte[] getUUID() {
        return this.kpxsprinuuid;
    }

    @Override
    public XSPrincipal.Flag getFlag() {
        return this.kpxsprinflg;
    }

    void doCharConversion(DBConversion dBConversion) throws SQLException {
        this.kpxsprinnameBytes = (byte[])(this.kpxsprinname != null ? dBConversion.StringToCharBytes(this.kpxsprinname) : null);
    }

    void marshal(T4CMAREngine t4CMAREngine) throws IOException {
        t4CMAREngine.marshalSB8(this.kpxsprindbid);
        if (this.kpxsprinnameBytes != null) {
            t4CMAREngine.marshalUB4(this.kpxsprinnameBytes.length);
            t4CMAREngine.marshalCLR(this.kpxsprinnameBytes, this.kpxsprinnameBytes.length);
        } else {
            t4CMAREngine.marshalUB4(0L);
        }
        if (this.kpxsprinuuid != null) {
            t4CMAREngine.marshalUB4(this.kpxsprinuuid.length);
            t4CMAREngine.marshalCLR(this.kpxsprinuuid, this.kpxsprinuuid.length);
        } else {
            t4CMAREngine.marshalUB4(0L);
        }
        t4CMAREngine.marshalUB4(this.kpxsprinflg.getMode());
    }

    static XSPrincipalI unmarshal(T4CMAREngine t4CMAREngine) throws SQLException, IOException {
        long l2;
        byte[] byArray;
        int[] nArray = new int[1];
        long l3 = t4CMAREngine.unmarshalSB8();
        String string = null;
        int n2 = (int)t4CMAREngine.unmarshalUB4();
        if (n2 > 0) {
            byArray = new byte[n2];
            t4CMAREngine.unmarshalCLR(byArray, 0, nArray);
            string = t4CMAREngine.conv.CharBytesToString(byArray, nArray[0]);
        }
        byArray = null;
        int n3 = (int)t4CMAREngine.unmarshalUB4();
        if (n3 > 0) {
            t4CMAREngine.unmarshalUB1();
            byArray = t4CMAREngine.unmarshalNBytes(n3);
        }
        XSPrincipal.Flag flag = (l2 = t4CMAREngine.unmarshalUB4()) == XSPrincipal.Flag.KPXS_PRIN_EXT.getMode() ? XSPrincipal.Flag.KPXS_PRIN_EXT : XSPrincipal.Flag.KPXS_PRIN_USEDBID;
        XSPrincipalI xSPrincipalI = new XSPrincipalI();
        xSPrincipalI.setDatabaseId(l3);
        xSPrincipalI.setName(string);
        xSPrincipalI.setUUID(byArray);
        xSPrincipalI.setFlag(flag);
        return xSPrincipalI;
    }
}

