/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Future<T>
implements java.util.concurrent.Future<T> {
    private volatile T value = null;
    private volatile long start = -1L;
    private volatile boolean cancelled = false;
    private volatile boolean done = false;

    public Future() {
    }

    public Future(T value) {
        this(value, true);
    }

    public Future(T value, boolean notify) {
        this.set(value, notify);
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.done || this.cancelled) {
            return false;
        }
        boolean bl = this.cancelled = mayInterruptIfRunning || this.start < 0L;
        if (mayInterruptIfRunning) {
            this.notifyAll();
        }
        return this.cancelled;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.done || this.cancelled;
    }

    public void set(T value, boolean notify) {
        if (notify) {
            this.set(value);
        } else {
            this.value = value;
        }
    }

    public synchronized void set(T value) {
        this.value = value;
        this.done = !this.cancelled;
        this.notifyAll();
    }

    public synchronized void reset() {
        this.start = -1L;
        this.cancelled = false;
        this.done = false;
    }

    public T getNow() {
        return this.value;
    }

    @Override
    public synchronized T get() throws InterruptedException, ExecutionException {
        try {
            return this.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        long millis;
        this.start = System.currentTimeMillis();
        long l = millis = timeout > 0L ? unit.toMillis(timeout) : 0L;
        while (!this.isDone()) {
            if (millis > 0L) {
                long remaining = millis + this.start - System.currentTimeMillis();
                if (remaining <= 0L) {
                    throw new TimeoutException(timeout + " " + (Object)((Object)unit) + " has elapsed.");
                }
                Future future = this;
                synchronized (future) {
                    this.wait(remaining);
                    continue;
                }
            }
            Future future = this;
            synchronized (future) {
                this.wait();
            }
        }
        return this.value;
    }
}

