<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:java="http://xml.apache.org/xalan/java"
	xmlns:mis="hybs-taglib.tld"
	exclude-result-prefixes="xsl jsp java mis" >

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"
			  omit-xml-declaration="yes"   />

  <xsl:param name="SYSTEM_ID" select="" />
  <xsl:param name="FILEPATH"  select="" />
  <xsl:param name="ADDRESS"   select="" />
  <xsl:param name="FILENAME"  select="" />
  <xsl:param name="MODIFIED"  select="" />
<!--
  <xsl:param name="DYSET"	  select='java:mis.pdm.fukurou.tools.util.DateSet.getDate( "yyyyMMddHHmmss" )' />
-->

  <xsl:param name="row_header" >
	 <SYSTEM_ID ><xsl:value-of select="$SYSTEM_ID" /></SYSTEM_ID>
	 <ADDRESS	><xsl:value-of select="$ADDRESS"   /></ADDRESS>
	 <FILENAME	><xsl:value-of select="$FILENAME"  /></FILENAME>
	 <FILEPATH	><xsl:value-of select="$FILEPATH"  /></FILEPATH>
	 <MODIFIED	><xsl:value-of select="$MODIFIED"  /></MODIFIED>
  </xsl:param>

  <xsl:template match="jsp:root" >
<!--
	 <xsl:if test="not(@version='2.0')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR01</MSGCD>
		 <MSGTXT >jsp:root タグのversion属性は、2.0 を指定してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
-->

	<xsl:apply-templates select="//mis:link" />
	<xsl:apply-templates select="//mis:sql | //mis:update" />
	<xsl:apply-templates select="//mis:option" />
	<xsl:apply-templates select="//mis:query" />
	<xsl:apply-templates select="//mis:userInfo" />
	<xsl:apply-templates select="//mis:view" />
	<xsl:apply-templates select="//mis:submit" />
	<xsl:apply-templates select="//mis:equals" />
	<xsl:apply-templates select="//mis:value" />
	<xsl:apply-templates select="//mis:entry" />
	<xsl:apply-templates select="//mis:viewLink" />
	<xsl:apply-templates select="//mis:viewMarker" />
	<xsl:apply-templates select="//mis:writeCheck" />
	<xsl:apply-templates select="//mis:input" />
	<xsl:apply-templates select="//*[starts-with( @onClick ,'window_open' )]" />
	<xsl:apply-templates select="//*[@tableId]" />
	<xsl:apply-templates select="//mis:columnCheck" />
	<xsl:apply-templates select="//mis:column | //mis:input | //mis:select | //mis:hidden | //mis:submit | //mis:textarea | //input | //select | //textarea"
						 mode="form-in" />
	<xsl:apply-templates select="//mis:hidden" />
	<xsl:apply-templates select="//form" />
	<xsl:apply-templates select="//frameset" />
	<xsl:apply-templates select="//mis:frame" />
	<xsl:apply-templates select="//*[@width] | //*[@height]" />
	<xsl:apply-templates select="//mis:message" />
	<xsl:apply-templates select="//mis:appear" />
	<xsl:apply-templates select="//mis:forward" />
	<xsl:apply-templates select="//mis:comment" />
	<xsl:apply-templates select="//mis:button" />
	<xsl:apply-templates select="//jsp:text" />

<!--
	<xsl:if test="not( starts-with( $FILENAME ,'forward' ) or starts-with( $FILENAME ,'index' ) ) and not(//mis:comment)" >
-->
	<xsl:if test="(starts-with( $FILENAME ,'query' ) or starts-with( $FILENAME ,'result' ) or starts-with( $FILENAME ,'update' ) or starts-with( $FILENAME ,'entry' ) ) and not(//mis:comment)" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD	>ERROR23</MSGCD>
		<MSGTXT >mis:comment タグを記述して下さい。</MSGTXT>
		<TEXT_DATA	><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
	</xsl:if>

	<xsl:if test="starts-with( $FILENAME ,'result' ) and not(//mis:errorMessage) and (//mis:writeCheck)" >
	  <ROW>
		<xsl:copy-of select="$row_header" />
		<TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		<MSGCD  >WARNING16</MSGCD>
		<MSGTXT >mis:errorMessage タグを記述して下さい。</MSGTXT>
		<TEXT_DATA	><xsl:copy-of select="." /></TEXT_DATA>
	  </ROW>
	</xsl:if>

  </xsl:template>

  <xsl:template match="mis:link" >
	 <xsl:if test="@value and not(preceding::mis:link)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR02</MSGCD>
		 <MSGTXT >mis:link タグのvalue属性は廃止属性です。vals 属性を使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@keys) and ( @value | @vals )" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR03</MSGCD>
		 <MSGTXT >mis:link タグのvals 属性とペアの keys属性が存在しません。keys,vals 属性はセットで使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@gamenId) and starts-with( @href ,'../' ) and not(@useGamenId='false')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR04</MSGCD>
		 <MSGTXT >mis:link タグで別画面へ飛ばす場合は、gamenId 属性を使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(@keys) and contains( @href ,'?' )" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR05</MSGCD>
		 <MSGTXT >mis:link タグの href でパラメータを渡す場合、keys,vals 属性を使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:sql | mis:update" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR06</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグは廃止クラスです。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="mis:option" >
	 <xsl:if test="@code" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR07</MSGCD>
		 <MSGTXT >mis:option タグのcode属性は廃止属性です。カラムリソースで、コードカラム属性を定義して使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="ancestor::mis:queryOption" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING18</MSGCD>
		 <MSGTXT >mis:option タグは、mis:queryOption タグのBODY部に入れずに、select タグの直下に配置してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:query" >
	 <xsl:if test="string-length( . ) &gt; 1000" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING01</MSGCD>
		 <MSGTXT >mis:query タグの設定文字数が多すぎます(制限1000文字)。QUERY文を見直してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:userInfo" >
	 <xsl:if test="@query" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR08</MSGCD>
		 <MSGTXT >mis:userInfo タグのquery属性は廃止属性です。属性そのものを削除可能です。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="@nullSet" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR09</MSGCD>
		 <MSGTXT >mis:userInfo タグのnullSet属性は廃止属性です。mis:value タグの使用を検討願います。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="last() &gt; 10 and position() = last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING02</MSGCD>
		 <MSGTXT >mis:userInfo タグを使いすぎです(制限10個)。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:view" >
	 <xsl:if test="@changeLabelKeys | @changeLabelVals" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR10</MSGCD>
		 <MSGTXT >mis:view タグのchangeLabel***属性は廃止属性です。columnEditor タグで、ラベルを入れ替える方法で代替してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="descendant::mis:message" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING03</MSGCD>
		 <MSGTXT >mis:message タグは、{@LBL.XXXX} に置き換え可能です。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:submit" >
	 <xsl:if test="not(//mis:writeCheck)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR11</MSGCD>
		 <MSGTXT >mis:submit タグは、mis:writeCheck タグの子要素として使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(starts-with( $FILENAME ,'query' ) and not(//mis:queryButton))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING19</MSGCD>
		 <MSGTXT >mis:submit タグが、mis:queryButton タグに置き換え可能か検討してしてください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:button" >
	 <xsl:if test="(starts-with( $FILENAME ,'query' ) and @type='submit' and not(//mis:queryButton))" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING20</MSGCD>
		 <MSGTXT >mis:button タグが、mis:queryButton タグに置き換え可能か検討してしてください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:equals" >
	 <xsl:if test="last() &gt; 10 and position() = last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING04</MSGCD>
		 <MSGTXT >mis:equals タグを使いすぎです(制限10個)。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:value" >
	 <xsl:if test="last() &gt; 10 and position() = last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING05</MSGCD>
		 <MSGTXT >mis:value タグを使いすぎです(制限10個)。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
<!--
	 <xsl:if test="count( //mis:value[@command='SQL' and contains( * ,'DUAL')] ) &gt; 1" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING06</MSGCD>
		 <MSGTXT >mis:value タグの SQL 構文で、DUAL を複数使用しています。まとめる事が可能か検討してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
-->
  </xsl:template>

  <xsl:template match="mis:entry" >
<!--
	 <xsl:if test="last() &gt; 1 and not(ancestor::mis:equals)" >
-->
	 <xsl:if test="(position() = last()) and count( //mis:entry[not(ancestor::mis:equals)] ) &gt; 1" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR12</MSGCD>
		 <MSGTXT >mis:entry タグが複数存在しています。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:viewLink" >
	 <xsl:if test="last() &gt; 1 and not(ancestor::mis:equals)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR13</MSGCD>
		 <MSGTXT >mis:viewLink タグが複数存在しています。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:viewMarker" >
	 <xsl:if test="last() &gt; 1 and not(ancestor::mis:equals)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR14</MSGCD>
		 <MSGTXT >mis:viewMarker タグが複数存在しています。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:writeCheck" >
	 <xsl:if test="last() &gt; 1 and not(ancestor::mis:equals)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING07</MSGCD>
		 <MSGTXT >mis:writeCheck タグが複数存在しています。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(descendant::mis:submit)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR11B</MSGCD>
		 <MSGTXT >mis:writeCheck タグの子要素には、mis:submit タグを使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:input" >
	 <xsl:if test="(//mis:writeCheck) and (@type='submit')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING08</MSGCD>
		 <MSGTXT >mis:input タグは、mis:writeCheck タグの子要素として使用しないでください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="*[starts-with( @onClick ,'window_open' )]" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING09</MSGCD>
		 <MSGTXT >window_open の代わりに、mis:popup タグの使用を検討してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
  </xsl:template>

  <xsl:template match="mis:columnCheck" >
	 <xsl:if test="preceding-sibling::mis:entry" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR15A</MSGCD>
		 <MSGTXT >mis:columnCheck タグでチェックする前に、mis:entry タグがあります。エラーの可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="not(following-sibling::mis:entry) and starts-with( $FILENAME ,'result' ) and (//mis:writeCheck)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR15B</MSGCD>
		 <MSGTXT >mis:columnCheck タグのチェック後に、mis:entry タグありません。エラーの可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(@nullCheck or @mustAnyCheck)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING17</MSGCD>
		 <MSGTXT >mis:columnCheck タグのnullCheck属性とmustAnyCheck属性は自動チェックされます。設定不要です。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="*[@tableId]" >
	 <xsl:if test="last() &gt; 3 and position() = last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING10</MSGCD>
		 <MSGTXT >tableId 属性を使いすぎです(制限3個)。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:column | mis:input | mis:select | mis:hidden | mis:submit | mis:textarea | input | select | textarea"
				mode="form-in" >
	 <xsl:if test="not(@writable='false' or @writable='FALSE') and not(ancestor::form) and not(ancestor::mis:viewMarker) and (following::form | preceding::form)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR16</MSGCD>
		 <MSGTXT ><xsl:value-of select="name()" /> タグが、form タグの中にありません。これはエラーの可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:hidden" >
	 <xsl:if test="@names" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR17</MSGCD>
		 <MSGTXT >mis:hidden タグのnames属性は廃止属性です。keys 属性を使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="(@name and @keys) or (@value and @vals) or (@name and @vals) or (@keys and @value)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR18</MSGCD>
		 <MSGTXT >mis:hidden タグは、name,value属性のペアか、keys,valsのペアで指定してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="form" >
	 <xsl:if test="descendant::mis:view and not(@method='POST')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING11</MSGCD>
		 <MSGTXT >テーブル登録時の form タグには、method="POST" を使用することを検討してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="descendant::mis:view and not(starts-with( @onSubmit ,'return oneClick' ) )" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING12</MSGCD>
		 <MSGTXT >テーブル登録時の form タグには、２度押し防止JavaScript( return oneClick(); )の使用を検討してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
	 <xsl:if test="starts-with( @action ,'../' )" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR19</MSGCD>
		 <MSGTXT >form タグの action 属性に、相対パスを使用するのは避けてください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="frameset" >
	 <xsl:if test="not(@name='SUB_FRAME') and not(@name='TOP_FRAME')" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING13</MSGCD>
		 <MSGTXT >フレーム分割(frameset)時の自動調整機能を有効にするには、name="SUB_FRAME" が必要です。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:frame" >
	 <xsl:if test="starts-with( @src ,'../' )" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR20</MSGCD>
		 <MSGTXT >mis:frame タグの src 属性に、相対パスを指定するのは、良くない慣習です。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="*[@width] | *[@height]" >
	 <xsl:if test="not( string(number( @width | @height ) ) = 'NaN' ) and not(name() = 'mis:chartCreate')">
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR21</MSGCD>
		 <MSGTXT >width や height 属性 を指定する場合は、単位(pt,px,%)が必要です。(IE7 必須)</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:message" >
	 <xsl:if test="last() &gt; 10 and position() = last()" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING14</MSGCD>
		 <MSGTXT >mis:message タグを使いすぎです(制限10個)。ソースを見直してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:appear" >
	 <xsl:if test="not(@defaultVal)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING15</MSGCD>
		 <MSGTXT >mis:appear タグで、defaultVal 属性を指定しないと、SQL構文エラーになる可能性があります。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:forward" >
	 <xsl:if test="not(@gamenId) and starts-with( @page ,'../' )" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR22</MSGCD>
		 <MSGTXT >mis:forward タグで別画面へ飛ばす場合は、gamenId 属性を使用してください。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>

  <xsl:template match="mis:comment" >
	 <xsl:if test="not(@system) or not(@pgid)" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >ERROR24</MSGCD>
		 <MSGTXT >mis:comment タグにシステム名、(system,pgid)を指定して下さい。</MSGTXT>
		 <TEXT_DATA	 ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>
	 </xsl:if>
  </xsl:template>
  
  <xsl:template match="jsp:text" >
	   <ROW>
		 <xsl:copy-of select="$row_header" />
		 <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
		 <MSGCD  >WARNING31</MSGCD>
		 <MSGTXT >jsp:text は、jsp:root 直下以外では使われなくなりました。</MSGTXT>
		 <TEXT_DATA   ><xsl:copy-of select="." /></TEXT_DATA>
	   </ROW>

    <xsl:if test="count( child::* ) &gt; 0" >
       <ROW>
         <xsl:copy-of select="$row_header" />
         <TAGNAME><xsl:value-of select="name()" /></TAGNAME>
         <MSGCD  >ERROR26</MSGCD>
         <MSGTXT >jsp:textタグの内部にタグを書くと、tomcat8以降でエラーとなります。jsp:textを削除するか、場合によってはCDATAを利用してください。</MSGTXT>
         <TEXT_DATA   ><xsl:copy-of select="." /></TEXT_DATA>
       </ROW>
     </xsl:if>
  </xsl:template>

</xsl:stylesheet>
