<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE7002"
	title    = "取込実績ﾃｰﾌﾞﾙ"
	date     = "2017/06/27"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- 開始時刻の範囲指定の初期値決め -->
<og:value command="SET" key="YMDFROM" value="{@NVL.DYFROM 000000}{@NVL.TMFROM 0000}00" />
<og:value command="SET" key="YMDTO"   value="{@NVL.DYTO 999999}{@NVL.TMTO 9999}99" />

<!-- NAME_JA は、extWhere.jsp で、別名を使えないので、JOINしていません -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" >
		select	A.SYSTEM_ID , A.RSRV_NO , A.FGTKAN , A.EXECID , B.NAME_JA
				 , A.TMSTR , A.TMEND
				 , A.FILE_IN , A.FILE_OK , A.FILE_NG , A.SUTORI , A.ERRMSG
				 , A.DYUPD , A.FGJ , A.UNIQ
		from GE71 A left outer join GE72 B
				on  A.EXECID=B.EXECID
				and rownum = 1
	<og:where>
		<og:and value = "A.SYSTEM_ID	=		'{@SYSTEM_ID}'"		/>
		<og:and value = "A.RSRV_NO		=		'{@RSRV_NO}'"		/>
		<og:and value = "A.EXECID		like	'{@EXECID}'"		/>
		<og:and value = "A.FGTKAN		=		'{@FGTKAN}'"		/>
		<og:and value = "A.TMSTR		&gt;=	'{@YMDFROM}'"		/>
		<og:and value = "A.TMSTR		&lt;	'{@YMDTO}'"			/>
		<og:and value = "A.FILE_IN		like	'{@FILE_IN}'"		/>
		<jsp:directive.include file="extWhere.jsp" />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "A.SYSTEM_ID,A.TMSTR DESC" />
</og:query>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ"
	writable	= "false"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
