/*
 * 7.4.2.1 (2021/05/21) スタートボタンで映像を「映像表示エリア」に表示
 *
 * yuicompressor-2.4.8og.jar で圧縮するとエラーになるため、jsp/common/option に、このままおいておきます。
 *
 *	<button id="videoStart" onClick="videoStart()">映像表示開始</button>
 *	<button id="capture" onClick="capture()">Capture</button>
 *
 *	<div id="videotop" style="display:flex;" >
 *		<video id="player" autoplay style="background-color: black;position: absolute;z-index: 1;"></video>
 *		<canvas id="snapshot" style="visibility:hidden;z-index: 2; "></canvas>
 *	</div>
 *
 *	<progress id="progressbar" > </progress>	進捗バー
 *	<textarea id="outdata" > </textarea>		OCRテキスト出力
 */
function videoStart() {
	// 操作する画面エレメント変数定義します。
	const player = document.getElementById('player');		// 映像表示エリア
	navigator.mediaDevices.getUserMedia({ video: true, audio: false })
		.then(stream => player.srcObject = stream)
		.catch(err => alert(`${err.name} ${err.message}`));
}

// 「静止画取得」ボタンが押されたら、canvas に映像のコマ画像を表示します。
function capture() {
	const snapshot = document.getElementById('snapshot');
	if( snapshot.style.visibility == "visible" ) {
		snapshot.style.visibility = "hidden" ;
	}
	else {
		snapshot.style.visibility = "visible" ;

		// 操作する画面エレメント変数定義します。
		const player = document.getElementById('player');		// 映像表示エリア
		const context = snapshot.getContext('2d');
		snapshot.width  = player.videoWidth;
		snapshot.height = player.videoHeight;

		context.drawImage(player, 0, 0);

		const outdata  = document.getElementById('outdata');
		if(outdata) {
//			outdata.innerHTML = "";
			outdata.value = "";
			ocr( snapshot,outdata );
		}
	}
}

/*
 * 7.4.2.1 (2021/05/21) File API による画像のOCR処理
 *
 *	<input type="file" id="imgfile" onChange="readOCR(this)" >  File API
 *	<img id="preview">							画像表示
 *	<progress id="progressbar" > </progress>	進捗バー
 *	<textarea id="outdata" > </textarea>		OCRテキスト出力
 */
function readOCR( target ) {
	const file = target.files[0];

	// imgタグのpreview領域があれば、イメージを表示する
	const preview = document.getElementById('preview');
	if( preview ) {
		var reader = new FileReader();
		reader.onload = function (evt) {
			preview.src=evt.target.result;
		}
		reader.readAsDataURL(file);
	}

	const outdata = document.getElementById('outdata');
	ocr( file,outdata );
}

function ocr( img,outdata ) {
	const progressbar = document.getElementById('progressbar');
	Tesseract.recognize(img,'jpn',{logger:m => { progressbar.value = m.progress;}})
		.then(({ data:{ text } }) => {
//			outdata.innerHTML = text;
//			outdata.textContent = text;
			outdata.value = text;
		});
}

// 映像から定期的に静止画を抽出する。
function qrParse(video){
	const canvas = new OffscreenCanvas(240, 320);
	const render = canvas.getContext("2d");

	return new Promise((res)=>{
		const loop = setInterval(()=>{
			render.drawImage(video, 0, 0, canvas.width, canvas.height);

			const img = render.getImageData(0, 0, canvas.width, canvas.height);
			const result = jsQR(img.data, img.width, img.height);

			// 解析結果が存在したら、100ms 繰り返し処理の解除を行い、QRデータを解決します
			if(result){
				clearInterval(loop);
				return res(result.data);
			}
		}, 100);
	});
}

// 「QR scan」ボタンが押されたらスキャンを開始する。
async function qrScan() {
	// 操作する画面エレメント変数定義します。
	const player = document.getElementById('player');		// 映像表示エリア
	const outdata  = document.getElementById('outdata');
//		outdata.innerHTML = await qrParse(player);
//		outdata.textContent = await qrParse(player);
	outdata.value = await qrParse(player);

	// 5秒後に スキャンを再開する。
	setTimeout( qrScan(),5000 );
}

function qrGenerate(data){
	const canvas = new OffscreenCanvas(1, 1);

	return new Promise((res, rej) =>
		 QRCode.toCanvas(canvas, data, {}, err => !err ? res(canvas) : rej(err)));
}

/*
 *	window.addEventListener('DOMContentLoaded', async()=>{
 *		const indata  = document.getElementById('indata');
 *		const snapshot = document.getElementById('snapshot');
 *		if( indata && snapshot ) {
 *			snapshot.getContext("bitmaprenderer")
 *				.transferFromImageBitmap((await qrGenerate(indata.textContent))
 *				.transferToImageBitmap());
 *		}
 *	});
*/

async function qrView( name ) {
	const indata = document.getElementById('div' + name);		// 値が設定されている div
	const canvas = document.getElementById('can' + name);		// 一時的に作成する canvas
	const imgtag = document.getElementById('img' + name);		// 最後にセットする img

	canvas.getContext("bitmaprenderer")
		.transferFromImageBitmap((await qrGenerate(indata.textContent))
		.transferToImageBitmap());

	imgtag.src = canvas.toDataURL();
}

function upload( args ) {
	var img = document.getElementById('snapshot').toDataURL();		// img変換

	img = img.replace('data:image/png;base64,', ''); 	// 初めの属性情報を削除

	// 未定義だと、undefined 文字列になってしまう。
	var param = 'img='+img ;
	if( args.dir   ) { param += '&dir='   + encodeURIComponent( args.dir   ); }
	if( args.file  ) { param += '&file='  + encodeURIComponent( args.file  ); }
	if( args.debug ) { param += '&debug=' + encodeURIComponent( args.debug ); }

	var xhr = new XMLHttpRequest();
	xhr.open( 'POST', '/gf/jsp/imageSave' );			// ｻｰﾌﾞﾚｯﾄで処理する。
	xhr.setRequestHeader('content-type','application/x-www-form-urlencoded');
	xhr.send( param );
}
