<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0001"
	title    = "ユーザー定義"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />
<og:entry command="{@command}" />

<!-- 7.2.9.5 (2020/11/28) sqlType はﾏｰｼﾞ対応。ﾒﾓﾘ内での重複ﾁｪｯｸも同時実行 -->
<!-- 7.2.9.5 (2020/11/28) ROLES はｷｰ項目から除外 -->
<og:dataCheck
	dbid		= "{@MEM.TO_DBID}"
	command 	= "{@command}"
	sqlType		= "{@sqlType}"
	from		= "GEA10"
	where		= "SYSTEM_ID=[SYSTEM_ID] AND USERID=[USERID]"
	uniqCheckClms	= "SYSTEM_ID,USERID"
	errRemove	= "{@errRemove}"
/>

<og:equals val1="{@sqlType}" val2="COPY" >
	<!-- COPY の場合は、FGDEFAULT は、'0':初期 のデータは、一つしか存在できません。-->
	<og:dataCheck
		dbid	= "{@MEM.TO_DBID}"
		command	= "{@command}"
		exist	= "false"
		conditionKey = "FGDEFAULT"
		conditionList = "0">
			SELECT COUNT(*) FROM GEA10
			WHERE SYSTEM_ID=[SYSTEM_ID] AND USERID=[USERID] AND FGDEFAULT='0' AND FGJ = '1'
	</og:dataCheck>
</og:equals>

<!-- 7.4.2.2 (2021/05/28) ﾊﾟｽﾜｰﾄﾞ更新時は、SYSTEM_ID 関係なく、同じ値に更新します -->
<og:equals val1="{@passwd}" val2="true" >
	<og:tableUpdate
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		queryType		= "JDBCTableUpdate">
		<og:tableUpdateParam
			sqlType			= "MODIFY"
			table			= "GEA10"
			where			= "USERID=[USERID]"
			names			= "PASSWD,DYPASSWD"
		/>
	</og:tableUpdate>
</og:equals>

<!-- 7.4.2.2 (2021/05/28) ﾊﾟｽﾜｰﾄﾞ更新時以外 -->
<og:equals val1="{@passwd}" nullCheck="true">
	<og:tableUpdate
		dbid			= "{@MEM.TO_DBID}"
		command			= "{@command}"
		queryType		= "JDBCTableUpdate">
		<og:tableUpdateParam
			sqlType			= "{@sqlType}"
			table			= "GEA10"
			where			= "SYSTEM_ID=[SYSTEM_ID] AND USERID=[USERID]"
			names			= "SYSTEM_ID,USERID,PASSWD,LANG,NAME_JA,ROLES,COMMENTS,DYPASSWD,DYVALID,FGDEFAULT,DROLES,MAILAD"
			logicalDelete	= "{@logicalDelete}"
		/>
	</og:tableUpdate>
</og:equals>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
