/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.system;

import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.opengion.fukurou.system.HybsConst;

public final class OgBuilder
implements CharSequence {
    private final StringBuilder buf = new StringBuilder(200);

    public OgBuilder append(CharSequence ... charSequenceArray) {
        if (charSequenceArray != null) {
            for (CharSequence charSequence : charSequenceArray) {
                if (charSequence == null) continue;
                this.buf.append(charSequence);
            }
        }
        return this;
    }

    public OgBuilder join(String string, CharSequence ... charSequenceArray) {
        if (string == null) {
            return this.append(charSequenceArray);
        }
        if (charSequenceArray != null) {
            boolean bl = false;
            for (CharSequence charSequence : charSequenceArray) {
                if (charSequence == null || charSequence.length() <= 0) continue;
                this.buf.append(charSequence).append(string);
                bl = true;
            }
            if (bl) {
                this.buf.setLength(this.buf.length() - string.length());
            }
        }
        return this;
    }

    public OgBuilder delete(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                int n;
                if (string == null) continue;
                int n2 = string.length();
                while ((n = this.buf.indexOf(string)) >= 0) {
                    this.buf.delete(n, n + n2);
                }
            }
        }
        return this;
    }

    public OgBuilder appendCR(CharSequence ... charSequenceArray) {
        return this.append(charSequenceArray).append(HybsConst.CR);
    }

    public OgBuilder appendNN(CharSequence ... charSequenceArray) {
        if (charSequenceArray != null && charSequenceArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder(200);
            for (CharSequence charSequence : charSequenceArray) {
                if (charSequence == null || charSequence.length() == 0) {
                    return this;
                }
                stringBuilder.append(charSequence);
            }
            this.buf.append((CharSequence)stringBuilder);
        }
        return this;
    }

    public OgBuilder appendIf(boolean bl, CharSequence ... charSequenceArray) {
        if (bl && charSequenceArray != null) {
            for (CharSequence charSequence : charSequenceArray) {
                if (charSequence == null) continue;
                this.buf.append(charSequence);
            }
        }
        return this;
    }

    public OgBuilder appendIfCR(boolean bl, CharSequence ... charSequenceArray) {
        return this.appendIf(bl, charSequenceArray).append(HybsConst.CR);
    }

    public <T, R> OgBuilder appendIf(boolean bl, T t, Function<? super T, ? extends R> function) {
        R r;
        if (bl && function != null && (r = function.apply(t)) != null) {
            this.buf.append(r);
        }
        return this;
    }

    public <R> OgBuilder appendRoop(int n, int n2, IntFunction<R> intFunction) {
        for (int i = n; i < n2; ++i) {
            R r = intFunction.apply(i);
            if (r == null) continue;
            this.buf.append(r);
        }
        return this;
    }

    public <R> OgBuilder appendRoop(int n, int n2, String string, IntFunction<R> intFunction) {
        boolean bl = true;
        for (int i = n; i < n2; ++i) {
            R r = intFunction.apply(i);
            if (r == null) continue;
            if (bl) {
                this.buf.append(r);
                bl = false;
                continue;
            }
            this.buf.append(string).append(r);
        }
        return this;
    }

    public OgBuilder appendCase(boolean bl, CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (bl) {
            if (charSequence != null) {
                this.buf.append(charSequence);
            }
        } else if (charSequenceArray != null) {
            for (CharSequence charSequence2 : charSequenceArray) {
                if (charSequence2 == null) continue;
                this.buf.append(charSequence2);
            }
        }
        return this;
    }

    public OgBuilder appendCase(boolean bl, Supplier<CharSequence[]> supplier, Supplier<CharSequence[]> supplier2) {
        block4: {
            block3: {
                if (!bl) break block3;
                CharSequence[] charSequenceArray = supplier.get();
                if (charSequenceArray == null) break block4;
                for (CharSequence charSequence : charSequenceArray) {
                    if (charSequence == null) continue;
                    this.buf.append(charSequence);
                }
                break block4;
            }
            CharSequence[] charSequenceArray = supplier2.get();
            if (charSequenceArray != null) {
                for (CharSequence charSequence : charSequenceArray) {
                    if (charSequence == null) continue;
                    this.buf.append(charSequence);
                }
            }
        }
        return this;
    }

    public StringBuilder getBuilder() {
        return this.buf;
    }

    public OgBuilder clear() {
        this.buf.setLength(0);
        return this;
    }

    @Override
    public char charAt(int n) {
        return this.buf.charAt(n);
    }

    @Override
    public int length() {
        return this.buf.length();
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.buf.subSequence(n, n2);
    }

    @Override
    public String toString() {
        return this.buf.toString();
    }
}

