/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.taglet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import java.util.HashMap;
import java.util.Map;
import org.opengion.fukurou.taglet.DocletTagWriter;
import org.opengion.fukurou.taglet.DocletUtil;

public final class DocletPlugin {
    private static final Map<String, AttKeySet> ATT_KEY_MAP = new HashMap<String, AttKeySet>();
    private static final String OG_FOR_SMPL = "og.formSample";
    private static final String ENCODE = "UTF-8";

    private DocletPlugin() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(RootDoc rootDoc) {
        String string = DocletUtil.getOption("-version", rootDoc.options());
        String string2 = DocletUtil.getOption("-outfile", rootDoc.options());
        try (DocletTagWriter docletTagWriter = null;){
            docletTagWriter = new DocletTagWriter(string2, ENCODE);
            docletTagWriter.printTag("<?xml version=\"1.0\" encoding=\"", ENCODE, "\" ?>");
            docletTagWriter.printTag("<javadoc>");
            docletTagWriter.printTag("  <version>", string, "</version>");
            docletTagWriter.printTag("  <description></description>");
            DocletPlugin.writeContents(rootDoc.classes(), docletTagWriter);
            docletTagWriter.printTag("</javadoc>");
        }
        return true;
    }

    private static void writeContents(ClassDoc[] classDocArray, DocletTagWriter docletTagWriter) {
        for (int i = 0; i < classDocArray.length; ++i) {
            String string;
            AttKeySet attKeySet;
            ClassDoc classDoc = classDocArray[i];
            if (!classDoc.isPublic() || (attKeySet = DocletPlugin.getAttGroupName(classDoc)) == null || (string = attKeySet.getAttKey(classDoc.name())) == null) continue;
            String string2 = classDoc.qualifiedName();
            Tag[] tagArray = classDoc.firstSentenceTags();
            Tag[] tagArray2 = classDoc.inlineTags();
            Tag[] tagArray3 = classDoc.tags(OG_FOR_SMPL);
            docletTagWriter.printTag("<classDoc>");
            docletTagWriter.printTag("  <attClass>", string2, "</attClass>");
            docletTagWriter.printTag("  <seq>", attKeySet.getSeq(), "</seq>");
            docletTagWriter.printTag("  <attKey>", string, "</attKey>");
            docletTagWriter.printTag("  <valueName>", attKeySet.getValueName(), "</valueName>");
            docletTagWriter.printTag("  <description>", tagArray, "</description>");
            docletTagWriter.printTag("  <contents>", tagArray2, "</contents>");
            docletTagWriter.printTag("  <formSample>", tagArray3, "</formSample>");
            docletTagWriter.printTag("</classDoc>");
        }
    }

    private static AttKeySet getAttGroupName(ClassDoc classDoc) {
        if (classDoc == null) {
            return null;
        }
        String string = classDoc.qualifiedName();
        AttKeySet attKeySet = ATT_KEY_MAP.get(string);
        if (attKeySet == null) {
            Type type = classDoc.superclassType();
            if (type != null) {
                attKeySet = DocletPlugin.getAttGroupName(type.asClassDoc());
            }
            if (attKeySet == null) {
                Type[] typeArray = classDoc.interfaceTypes();
                for (int i = 0; i < typeArray.length && (attKeySet = DocletPlugin.getAttGroupName(typeArray[i].asClassDoc())) == null; ++i) {
                }
            }
        }
        return attKeySet;
    }

    public static int optionLength(String string) {
        if ("-version".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("-outfile".equalsIgnoreCase(string)) {
            return 2;
        }
        return 0;
    }

    static {
        int n = 0;
        ATT_KEY_MAP.put("org.opengion.hayabusa.db.Query", new AttKeySet("Query", n++, "queryType"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.db.CellRenderer", new AttKeySet("Renderer", n++, "renderer"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.db.CellEditor", new AttKeySet("Editor", n++, "editor"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.db.DBType", new AttKeySet("DBType", n++, "dbType"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.db.TableFilter", new AttKeySet("TableFilter", n++, "tableFilter"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.db.Selection", new AttKeySet("Selection", n++, "selection"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.db.DBConstValue", new AttKeySet("DBConstValue", n++, "cnstVal"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.html.ViewForm", new AttKeySet("ViewForm", n++, "viewFormType"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.io.TableWriter", new AttKeySet("TableWriter", n++, "writerClass"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.io.TableReader", new AttKeySet("TableReader", n++, "readerClass"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.resource.CalendarQuery", new AttKeySet("CalendarQuery", n++, "calDB"));
        ATT_KEY_MAP.put("org.opengion.hayabusa.resource.CalendarData", new AttKeySet("CalendarData", n++, "calData"));
        ATT_KEY_MAP.put("org.opengion.fukurou.process.HybsProcess", new AttKeySet("Process", n++, "process"));
        ATT_KEY_MAP.put("org.opengion.fukurou.util.HybsTimerTask", new AttKeySet("Daemon", n++, "daemon"));
        ATT_KEY_MAP.put("org.opengion.fukurou.util.ConnectIF\t", new AttKeySet("ConnectIF", n++, "connIF"));
        ATT_KEY_MAP.put("org.opengion.fukurou.xml.JspParserFilter", new AttKeySet("JspCreate", n++, "jspParser"));
    }

    private static final class AttKeySet {
        private final String searchKey;
        private final int len;
        private final String seq;
        private final String valueName;

        AttKeySet(String string, int n, String string2) {
            this.searchKey = string;
            this.seq = String.valueOf(n);
            this.valueName = string2;
            this.len = string.length();
        }

        String getSeq() {
            return this.seq;
        }

        String getValueName() {
            return this.valueName;
        }

        String getAttKey(String string) {
            Object object = null;
            if (string.equals(this.searchKey)) {
                object = "(Interface)" + string;
            } else if (string.indexOf(this.searchKey) == 0 && ((String)(object = string.substring(this.len))).charAt(0) == '_') {
                object = ((String)object).substring(1);
            }
            return object;
        }
    }
}

