/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.servlet.multipart;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;

public class PartInputStream
extends FilterInputStream {
    private final String boundary;
    private final byte[] buf = new byte[65536];
    private int count;
    private int pos;
    private boolean eof;

    PartInputStream(ServletInputStream servletInputStream, String string) throws IOException {
        super((InputStream)servletInputStream);
        this.boundary = string;
    }

    private void fill() throws IOException {
        if (this.eof) {
            return;
        }
        if (this.count > 0) {
            if (this.count - this.pos == 2) {
                System.arraycopy(this.buf, this.pos, this.buf, 0, this.count - this.pos);
                this.count -= this.pos;
                this.pos = 0;
            } else {
                throw new IllegalStateException("fill() detected illegal buffer state");
            }
        }
        int n = this.buf.length - this.boundary.length();
        while (this.count < n) {
            int n2 = ((ServletInputStream)this.in).readLine(this.buf, this.count, this.buf.length - this.count);
            if (n2 == -1) {
                throw new IOException("unexpected end of part");
            }
            if (n2 >= this.boundary.length()) {
                this.eof = true;
                for (int i = 0; i < this.boundary.length(); ++i) {
                    if (this.boundary.charAt(i) == this.buf[this.count + i]) continue;
                    this.eof = false;
                    break;
                }
                if (this.eof) break;
            }
            this.count += n2;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.count - this.pos <= 2) {
            this.fill();
            if (this.count - this.pos <= 2) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 == 0) {
            return 0;
        }
        int n4 = this.count - this.pos - 2;
        if (n4 <= 0) {
            this.fill();
            n4 = this.count - this.pos - 2;
            if (n4 <= 0) {
                return -1;
            }
        }
        int n5 = Math.min(n2, n4);
        System.arraycopy(this.buf, this.pos, byArray, n, n5);
        this.pos += n5;
        for (n3 = n5; n3 < n2; n3 += n5) {
            this.fill();
            n4 = this.count - this.pos - 2;
            if (n4 <= 0) {
                return n3;
            }
            n5 = Math.min(n2 - n3, n4);
            System.arraycopy(this.buf, this.pos, byArray, n + n3, n5);
            this.pos += n5;
        }
        return n3;
    }

    @Override
    public int available() throws IOException {
        int n = this.count - this.pos - 2 + this.in.available();
        return n < 0 ? 0 : n;
    }

    @Override
    public void close() throws IOException {
        if (!this.eof) {
            int n = this.read(this.buf, 0, this.buf.length);
            while (n != -1) {
                n = this.read(this.buf, 0, this.buf.length);
            }
        }
    }
}

