<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジンサンプル"
	pgid	= "GE0001"
	title	= "ユーザー定義"
	date	= "2007/12/12"
	author	= "K.HASEGAWA"
	text	= "ZZZZ"
	version	= "001"
>
	5.6.6.0 2013/07/05 ROLE検索方法変更
</og:comment>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command	= "{@command}"
	columns	= "SYSTEM_ID,NAME_JA,ROLES"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<og:query command="{@command}" debug="{@debug}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}">
	select USERID,PASSWD,LANG,NAME_JA,ROLES,'' as POP1,
			COMMENTS,DYVALID,DYPASSWD,MAILAD,SYSTEM_ID,FGJ,UNIQ
	from GEA10
	<og:where>
		<og:and value = "FGJ			=	 '{@FGJ}'"			/>
		<og:and value = "SYSTEM_ID		=	 '{@SYSTEM_ID}'"	/>
		<og:and value = "USERID			like '{@USERID}'"		/>
		<og:and value = "NAME_JA		like '{@NAME_JA}'"		/>
		<og:and value = "LANG			=	 '{@LANG}'"			/>
		<og:and value = "ROLES			like '{@ROLES}'"		/>
		<og:and value = "DYUPD			&gt;= '{@DYUPDFROM}'"	/>
		<og:and value = "DYUPD			&lt;= '{@DYUPDTO}99'"	/>
		<og:and value = "USRUPD			=	 '{@USRUPD}'"		/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,USERID" />
</og:query>

<og:columnEditor columns="SYSTEM_ID,USERID,PASSWD,ROLES" must="true" />
<og:columnEditor columns="POP1" label="" />										<!-- 1.6.1 (2021/03/01) og:popup タグ化 -->

<!-- 1.6.1 (2021/03/01) og:popup タグ化 -->
<og:value command="SET" key="param1" >
select ROLES,NMROLE from GEA05 where SYSTEM_ID=\'{@SYSTEM_ID}\' and FGJ=\'1\'
</og:value>

<og:viewMarker isRenderer="false" command="NEW">
	<!-- 1.6.1 (2021/03/01) og:popup タグ化 -->
	<og:columnMarker column="ROLES"  />
	<og:popup column="POP1" href="{@SYS.JSP}/custom/multiChoose.jsp" rtnKeys="ROLES"
			keys="name,SYSTEM_ID,editor,toVals,param"
			vals='ROLES,{@SYSTEM_ID},DBMENU,"[ROLES].value","{@param1}"'
			height="200px" width="500px" src="{@SYS.JSP_IMG}/multiChoose.gif" />
</og:viewMarker>

<form method="POST" action="forward.jsp" target="RESULT">
	<og:writeCheck>
		<og:equals val1="{@ACTION}" nullCheck="true">
			<og:input name="repeatCount" value="1" lbl="" td="false" size="2" />
			<og:submit action="COPY"	noWritable="DYPASSWD,FGJ" />
			<og:submit action="MODIFY"	noWritable="SYSTEM_ID,USERID,PASSWD,DYPASSWD,FGJ"  />
			<og:submit action="DELETE"	columnWritable="null"  keys="logicalDelete" vals="true" />
			<og:submit action="DELETE"	columnWritable="null" lbl="DELETE_PH" roles="DEL" accesskey="" />

			<og:submit  action="MODIFY"  columnWritable="PASSWD" lbl="PASSWD" keys="passwd" vals="true" />

			<fieldset style="display:inline;">
				<legend><strong><og:message lbl="INSERT_GEA10" /></strong></legend>
				<og:column name="SYSTEM_ID" useRequestValue="false" must="true" td="no" />
				<og:submit action="COPY" noWritable="DYPASSWD" keys="sysins" vals="true" accesskey="" />
			</fieldset>
		</og:equals>
		<og:equals val1="{@ACTION}" val2="MINUS">
			<og:submit action="COPY" noWritable="DYPASSWD" />
		</og:equals>
		<og:equals val1="{@ACTION}" val2="DIFFERENCE">
			<og:submit action="MODIFY" noWritable="SYSTEM_ID,USERID,PASSWD,DYPASSWD" />
		</og:equals>
		<br />
	</og:writeCheck>

<!-- ACTION が指定された場合は、tableMerge により積集合/差分集合を取得します。 -->
<og:equals val1="{@ACTION}" val2="{@ACTION}">
	<og:query dbid="{@TO_DBID}" scope="request" quotCheck="false" maxRowCount="{@maxRowCount}" mainTrans="false">
		{@USER.LASTSQL}
	</og:query>

	<og:tableMerge
		action		= "{@ACTION}"
		masterScope	= "session"
		masterKeys	= "SYSTEM_ID,USERID"
		diffKeys	= "PASSWD,LANG,NAME_JA,ROLES,COMMENTS,DYVALID,DYPASSWD,MAILAD"
		slaveScope	= "request"
		modifyClms	= "UNIQ,UNIQ_GEA10"
		display		= "true"
	/>
</og:equals>

<og:view
	viewFormType	= "HTMLTable"
	command			= "{@command}"
	noDisplay		= "UNIQ"
	checked			= "{@checked}"
	startNo			= "{@startNo}"
	pageSize		= "{@pageSize}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
