<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useAjaxSubmit="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジンサンプル"
	pgid	= "GE0001"
	title	= "ユーザー定義"
	date	= "2007/12/12"
	author	= "K.HASEGAWA"
	text	= "ZZZZ"
	version	= "001"
/>

<!-- データが選ばれていなければエラー -->
<og:equals val1="{@sysins}" val2="true">
	<og:columnCheck
		checkType = "NEW"
		nullCheck = "SYSTEM_ID">
		<jsp:directive.include file="/jsp/common/history_back.jsp" />
	</og:columnCheck>
</og:equals>

<og:columnCheck command="{@command}">
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<og:entry command="{@command}" repeatCount="{@repeatCount}">
	<og:columnSet command="COPY" columnId="USERID"		action="NULLSET" value="{@MEM.USERID}" />
	<og:columnSet command="COPY" columnId="PASSWD"		action="CLEAR" />
	<og:columnSet command="COPY" columnId="DYPASSWD"	action="SET" value="{@USER.YMDH}" />
	<og:equals val1="{@sysins}" val2="true">
		<og:columnSet command="COPY" columnId="SYSTEM_ID" action="SET" value="{@SYSTEM_ID}" />
	</og:equals>
	<og:equals val1="{@passwd}" val2="true">
		<og:columnSet command="MODIFY" columnId="PASSWD"	action="CLEAR" />
		<og:columnSet command="MODIFY" columnId="DYPASSWD"	action="SET" value="{@USER.YMDH}" />
	</og:equals>
</og:entry>

<og:message command="{@command}" /><br />
<form method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit action="ENTRY" />
	<og:submit action="RESET" />
	<og:input type="reset" name="command" lbl="MSG0011" td="false" />
</og:writeCheck>

<og:view
	viewFormType	= "HTMLTable"
	command			= "{@command}"
	noDisplay		= "UNIQ"
	columnWritable	= "{@columnWritable}"
	noWritable		= "{@noWritable}"
	startNo			= "{@startNo}"
	checked			= "{@checked}"
	pageSize		= "{@pageSize}"
	columnBulkSet	= "*" />

<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />
<og:hidden name="logicalDelete" value="{@logicalDelete}" />
<og:hidden name="passwd" value="{@passwd}" />					<!-- 7.4.2.2 (2021/05/28) -->

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
