<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE0018"
	title    = "データロール"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<og:columnCheck command="{@command}" />
<og:entry command="{@command}" />

<!-- COPY|INSERT の場合は、ﾛｰﾙﾏｽﾀ に存在しない(ﾛｰﾙ区分(KBROLE)=2:ﾃﾞｰﾀﾛｰﾙ)に存在しなければ、エラーにします。 -->
<og:equals val1="COPY|INSERT" val2="{@sqlType}" contains="true">
	<og:dataCheck
		dbid	= "{@MEM.TO_DBID}"
		command	= "{@command}"
		from	= "GEA05"
		exist	= "true"
		where	= "SYSTEM_ID=[SYSTEM_ID] AND ROLES=[DROLE] AND KBROLE='2'"
	/>
</og:equals>

<!-- 7.2.9.5 (2020/11/28) sqlType はﾏｰｼﾞ対応。ﾒﾓﾘ内での重複ﾁｪｯｸも同時実行 -->
<og:dataCheck
	dbid		= "{@MEM.TO_DBID}"
	command 	= "{@command}"
	sqlType		= "{@sqlType}"
	from		= "GEA06"
	where		= "SYSTEM_ID=[SYSTEM_ID] AND DROLE=[DROLE] AND CLM=[CLM] AND CVALUE=[CVALUE] AND VALCDTN=[VALCDTN]"
	uniqCheckClms	= "SYSTEM_ID,DROLE,CLM,CVALUE,VALCDTN"
	errRemove	= "{@errRemove}"
/>

<og:tableUpdate
	command			= "{@command}"
	queryType		= "JDBCTableUpdate">
	<og:tableUpdateParam
		sqlType			= "{@sqlType}"
		table			= "GEA06"
		names			= "SYSTEM_ID,DROLE,CLM,CVALUE,VALCDTN"
		where			= "SYSTEM_ID=[SYSTEM_ID] AND DROLE=[DROLE] AND CLM=[CLM] AND CVALUE=[CVALUE] AND VALCDTN=[VALCDTN]"
		logicalDelete	= "{@logicalDelete}"
	/>
</og:tableUpdate>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
