<?xml version="1.0" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP05"
	title    = "定義マスタ"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
>
	2018/05/31	T.OTA	05200-180522-02	一覧にﾒｰﾙ不要ﾌﾗｸﾞ項目を追加。
</og:comment>

<!-- 変更はここからです。 -->

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェックを行います。 -->
<!-- 入力内容がNULLの場合にエラーを返したい場合は、nullCheck属性を追加して下さい。-->
<og:columnCheck
	command = "{@command}"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DBを検索するための SQL文を記述します。 debug="true" で画面からSQL文を確認できます。 -->
<!-- 2018/05/31 FGNOMLを追加 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select
			LISTID,LISTNAME,MODELDIR,MODELFILE,FGCUT,COMMENTS,FGLOCAL,FGDIRECT,FGNOML,SYSTEM_ID,
			RDC_CODE,RELEASE_NOTES,OPTIONS,{@details}FGJ,DYUPD
		from GE54

	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "SYSTEM_ID = '{@SYSTEM_ID}'"	/>
		<og:and value = "LISTID LIKE '{@LISTID}%'"			/>
		<og:and value = "FGJ in ('0','1')"					/>
		<og:and value = "LISTNAME LIKE '{@LISTNAME}%'"		/>
		<og:and value = "MODELFILE LIKE '{@MODELFILE}%'"	/>
		<og:and value = "RDC_CODE   = '{@RDC_CODE}'"   />
		<og:and value = "DYUPD  &gt;= '{@DYUPDFROM}'"  />
		<og:and value = "DYUPD  &lt;= '{@DYUPDTO}99'"  />
		<og:and value = "RELEASE_NOTES like '{@RELEASE_NOTES}%'" />
		<og:and value = "FGLOCAL 	= '{@FGLOCAL}'" />
		<og:and value = "FGDIRECT 	= '{@FGDIRECT}'" />
		<og:and value = "FGNOML		= '{@FGNOML}'" />	<!-- 2018/05/31 ADD -->
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,LISTID" />
</og:query>

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->
<og:columnEditor column="SYSTEM_ID" must="true" />
<og:columnEditor column="LISTID"    must="true" />
<og:columnEditor column="MODELDIR"  must="true" />
<og:columnEditor column="MODELFILE" must="true" />

<og:viewLink command="{@command}">
	<og:link column="LISTID" gamenId="REP03" href="index.jsp" target="CONTENTS"
			keys="command,SYSTEM_ID,LISTID" vals="NEW,[SYSTEM_ID],[LISTID]" />
</og:viewLink>

<form method="POST" action="forward.jsp" target="RESULT">

<!-- 追加、複写、変更、削除ボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="Z" />

</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<og:equals val1="{@details}" nullCheck="true"  >
	<og:view
		viewFormType = "HTMLTable"
		command 	 = "{@command}"
		checked      = "{@checked}"
		startNo      = "{@startNo}"
		pageSize     = "{@pageSize}"
	/>
</og:equals>

<!-- 2018/05/31 FGNOMLを追加。 rowspanの数値を変更。-->
<og:equals val1="{@details}" val2="{@details}" >
	<og:view
		viewFormType = "HTMLFormatTable"
		command 	 = "{@command}"
		checked      = "{@checked}"
		startNo      = "{@startNo}"
		pageSize     = "{@pageSize}"
		useScrollBar = "false"
		rowspan      = "9"  >
<tr><td>[LISTID]</td><td rowspan="9">[OPTIONS]</td><td rowspan="9">[BSQL]</td><td rowspan="9">[HSQL]</td><td rowspan="9">[FSQL]</td></tr>
<tr><td>[LISTNAME]</td></tr>
<tr><td>[MODELDIR]</td></tr>
<tr><td>[MODELFILE]</td></tr>
<tr><td>[FGCUT]</td></tr>
<tr><td>[COMMENTS]</td></tr>
<tr><td>[FGLOCAL]</td></tr>
<tr><td>[FGNOML]</td></tr>
<tr><td>[SYSTEM_ID]</td></tr>
	</og:view>
</og:equals>

<og:hidden name="SYSTEM_ID" value="{@SYSTEM_ID}" />

</form>

<!-- 変更はここまでです。 -->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
