<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GG0020"
	title	= "雛形設定ﾏｽﾀ"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>

<!-- エラー時に戻るボタンを表示します。-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck を含め、すべて自動で処理されます。-->
<og:columnCheck command="{@command}" />

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}"  />

<!-- TableExistTag は、command="ENTRY" のときのみ有効です。-->
<og:dataCheck command="{@command}" sqlType="{@sqlType}">
	select count(*) from GG02
	where SET_GRP=[SET_GRP] AND TOKEN=[TOKEN] AND FGJ=[FGJ]
</og:dataCheck>

<!-- 前画面のSQL文を実行する場合に、tableUpdate の queryType="JDBCTableUpdate"を指定します。-->
<!-- 通常は変更する必要はありません。 -->
<og:transaction>
	<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate" debug="{@debug}">
		<og:tableUpdateParam
			sqlType= "{@sqlType}"
			table  = "GG02"
			where  = "SET_GRP=[SET_GRP] AND TOKEN=[TOKEN] AND FGJ=[FGJ]"
			omitNames = "UNIQ,VIEW_LEN,TANI,DATA_TYPE,TKN_GRP,BIKO"
		/>
	</og:tableUpdate>
</og:transaction>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
