<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GG0030"
	title	= "選択ﾏｽﾀ"
	date	= "2021/03/25"
	author	= "K.HASEGAWA"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" >
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select 	SEL_TYPE,SEL_KEY,SEQNO,SEL_VAL,SEL_NM,SEL_GRP,MARKER,
				UNIQ,FGJ,USRSET,DYSET,USRUPD,DYUPD
		from GG03
	<og:where>
		<og:and value = "SEL_TYPE	= '{@SEL_TYPE}'"	/>
		<og:and value = "SEL_KEY	like  '{@SEL_KEY}'"	/>
		<og:and value = "SEL_VAL	like '{@SEL_VAL}'"	/>
		<og:and value = "SEL_NM		like '{@SEL_NM}'"	/>
		<og:and value = "SEL_GRP	like '{@SEL_GRP}'"	/>
		<og:and value = "MARKER		like '{@MARKER}'"	/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SEL_TYPE,SEL_KEY,SEL_GRP,SEQNO" />
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->
<og:columnEditor columns="SEL_TYPE,SEL_KEY,SEQNO,SEL_VAL"	must="true" />

<og:viewLink command="{@command}">
	<og:link column="SEL_VAL" gamenId="GG0030" href="index.jsp" target="CONTENTS" onLink="[SEL_TYPE]" markList="1"
		keys="command,SEL_TYPE,SEL_KEY,SEL_GRP"
		vals="NEW,2,[SEL_VAL],[SEL_GRP]" />
</og:viewLink>

<!-- ViewMarkerTag	-->
<og:viewMarker command="NEW">
	<og:columnMarker column="MARKER" >
		<span style="[MARKER]">[MARKER]</span>
	</og:columnMarker>
</og:viewMarker>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form method="POST" action="forward.jsp" target="RESULT" >
	<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
	<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
		<og:submit  action="COPY"    noWritable="null" />
		<og:submit  action="MODIFY"  noWritable="FGJ,SEL_TYPE,SEL_KEY,SEL_VAL"  />
		<og:submit  action="DELETE"  columnWritable="null" />
	<br />
	</og:writeCheck>

	<!-- DB検索結果を表示させます。 -->
	<!-- checked="true" で、チェック済みの状態で表示できます。 -->
	<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
	<og:view
		viewFormType = "HTMLTable"
		command    = "{@command}"
		noDisplay  = "UNIQ,USRSET,DYSET,USRUPD,DYUPD,{@extDisplay}"
		checked    = "{@checked}"
		startNo    = "{@startNo}"
		pageSize   = "{@pageSize}"
	/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
