<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<!-- POPUPでは、自分自身にsubmiするため、headType="popup" の記述が必要です。 -->
<og:head headType="popup" />

<jsp:directive.include file="/jsp/custom/popup_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6050"
	title	= "ポップアップ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME"
/>

<form method="GET" action="popup.jsp" >

	<!-- 変更はここから -->
	<table summary="layout" >
	<tr>
		<og:column name="SYSTEM_ID" defaultVal="{@LAST.SYSTEM_ID}" must="true" />
		<og:column name="LANG" aimai="V*" defaultVal="{@USER.LANG}" />
		<og:column name="KBSAKU" />
	</tr>
	<tr>
		<og:column name="CLM" aimai="V*" />
		<og:column name="NAME_JA" aimai="V*"/>
		<og:column name="LABEL_NAME" aimai="V*" />
	</tr>
	</table>

	<!-- POPUPでは、scope="request" で検索するので、PrevNextは表示しません。 -->
	<og:queryButton usePrevNext="false" useEditMenu="false"  useClear ="false" />
</form>

<hr />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME"
	nullCheck = "SYSTEM_ID"
	checkType = "NEW"
/>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->

<!-- POPUPでは、scope="request" で検索します。 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" scope="request">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select CASE KBSAKU WHEN '3' THEN '1' ELSE KBSAKU END AS WRITABLE,
				CLM,NAME_JA,LABEL_NAME,KBSAKU,SYSTEM_ID,LANG
		from GF41
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"         />
		<og:and value = "SYSTEM_ID   =  '{@SYSTEM_ID}'"  />
		<og:and value = "LANG        like '{@LANG}'"       />
		<og:and value = "CLM         like '{@CLM}'"        />
		<og:and value = "NAME_JA     like '{@NAME_JA}'"    />
		<og:and value = "LABEL_NAME  like '{@LABEL_NAME}'" />
		<og:and value = "KBSAKU      =    '{@KBSAKU}'"      />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<!-- viewタグでpopupReturnKeysを設定するとポップアップ時に値を返します -->
<!-- POPUPでは、scope="request" 、selectedType = "radio" で、１件選択するようにします。 -->
<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	scope      = "request"
	selectedType = "radio"
	popupReturnKeys = "SYSTEM_ID,CLM,NAME_JA,LANG,KBSAKU"
	mainView  = "false"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
