<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" >
	<style type="text/css">
		.x7698 { background-color:#ccff00; }
		.MANAGER { background-color:#ccff00; }
	</style>
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6070"
	title	= "クロス集計"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
/>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		SELECT DEPTNO,JOB,MGR,sum(SAL) as KEI,min(SAL) as MIN , max(SAL) as MAX
		FROM EMP
		GROUP BY DEPTNO,JOB,MGR
		ORDER BY 1,2
</og:query>

<og:columnEditor column="MGR"				 renderer="DBMENU" param="select MGR,ENAME from EMP" />
<og:columnEditor column="DEPTNO" dbType="KX" renderer="DBMENU" param="select DEPTNO,DNAME from DEPT" />

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="JOB" gamenId="GF9100" href="index.jsp" target="CONTENTS"
		keys="command,JOB,KEI"
		vals="NEW,[JOB],[KEI]" />
	<og:link column="KEI" gamenId="GF9100" href="index.jsp" target="CONTENTS"
		keys="command,KEI"
		vals="NEW,[KEI]" />
<!--
  <og:equals val1="{@useHeaderColumn}" val2="true" >
	<og:link column="7782" gamenId="GF9100" href="index.jsp" target="CONTENTS"
		keys="command,JOB,SUM"
		vals="NEW,[JOB],[7782]" />
	<og:link column="7566" gamenId="GF9100" href="index.jsp" target="CONTENTS" onLink="[DEPTNO]" markList="20"
		keys="command,JOB,SUM"
		vals="NEW,[JOB],[7566]" />
  </og:equals>
-->
</og:viewLink>

<og:value command="SET" key="KEI_VIEW" value='KEI,MIN,MAX' caseKey="{@keiView}" caseVal="false" />

<og:view
	viewFormType = "HTML{@CROSS}Table"
	command		= "{@command}"
	checked		= "{@checked}"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}"
	useParam	= "true"
	noDisplay  = "{@KEI_VIEW}"
  >
	<og:crossParam
		gokeiLabel		= "GOKEI"
		sumNumber		= "3"
		cubeXColumn		= "JOB"
		cubeYColumn		= "MGR"
		cubeSortType	= "{@cubeSortType}"
		gokeiSortDir	= "{@gokeiSortDir}"
		saveTableId		= "{@saveTableId}"
		useClassAdd		= "{@useClassAdd}"
		firstClmGokei	= "{@firstClmGokei}"
		useHeaderColumn = "{@useHeaderColumn}"
		useHeaderResource	= "{@useHeaderResource}"
	/>
</og:view>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
