<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "ORA06"
	title	= "EXPLAIN"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:transaction>
	<og:query command="{@command}" notfoundMsg="" scope="request" dbid="{@DBID}">
		delete from plan_table where statement_id = '{@USER.ID}'
	</og:query>

	<og:query command="{@command}" notfoundMsg="" scope="request" dbid="{@DBID}" quotCheck="false">
		explain plan set statement_id = '{@USER.ID}' for {@SQL}
	</og:query>

	<og:query command="{@command}" notfoundMsg="" scope="request" dbid="{@DBID}" >
			select LEVEL as LVL
				,lpad(' ',LEVEL,' ') || rtrim( OPERATION ) || ' ' || rtrim( OPTIONS ) || ' ' || rtrim( OBJECT_NAME ) as EXECUTION_PLAN
				,decode( instr(OPTIONS,'FULL'),null,'false',0,'false','true' ) as FULL
				,OBJECT_OWNER		as OWNER
				,OBJECT_NAME		as OBJ_NAME
				,DECODE(INSTR(OBJECT_TYPE,' '),0,OBJECT_TYPE,SUBSTR(OBJECT_TYPE,1,INSTR(OBJECT_TYPE,' ')-1)) as OBJ_TYPE
				,OPTIMIZER			as OPT
				,COST				as CST
				,CARDINALITY		as CARD
				,BYTES				as BYTE
				,ACCESS_PREDICATES	as ACCS
				,FILTER_PREDICATES	as FILTER
			from PLAN_TABLE
			where STATEMENT_ID = '{@USER.ID}'
			start with ID = 0
				  and STATEMENT_ID = '{@USER.ID}'
			connect by prior ID = PARENT_ID
				  and STATEMENT_ID = '{@USER.ID}'
	</og:query>
</og:transaction>

<og:viewLink command="{@command}">
	<og:link column="OBJ_NAME" href="viewObject.jsp" target="SUB_WIND"
		keys="command,OWNER,TYPE,NAME,DBID" vals="NEW,[OWNER],[OBJ_TYPE],[OBJ_NAME],{@DBID}" />
</og:viewLink>

<og:viewMarker command="{@command}" >
	<og:columnMarker column="EXECUTION_PLAN" onMark="[FULL]" >
		<span id="warning">[EXECUTION_PLAN]</span>
	</og:columnMarker>
</og:viewMarker>

<og:columnEditor column="EXECUTION_PLAN" scope="request" renderer="PRE"   />

<og:view
	scope      = "request" 
	viewFormType = "HTMLTable" 
	command    = "{@command}" 
	noDisplay  = "FULL,OWNER"
	writable   = "false"
	startNo    = "{@startNo}" 
	pageSize   = "{@pageSize}" 
	noMessage  = "true"
/>

<!-- EXECUTION_PLAN の SQL が設定されてしまうので、戻す -->
<og:userInfo command="SET" key="USER.LASTSQL" value="{@SQL}" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
