/*
 * dragUpload.js
 * ファイルのドラッグ＆ドロップでupload.jspをCallする。
 * 互換モードの場合はファイル選択で通常のアップロード。
 * IEのみ（chromeなどではアップロード先が対応している必要がある）
 *
*/

$(function(){
	var count = 0;			//アップロードバー用の通し番号
	/*================================================
	ファイルをドロップした時の処理
	=================================================*/
	$('#drag-area').bind('drop', function(e){
	// デフォルトの挙動を停止
	 e.preventDefault();

	// ファイル情報を取得
	var files = e.originalEvent.dataTransfer.files;
	count++;
	uploadFiles(files,count);

	}).bind('dragenter', function(){
	// デフォルトの挙動を停止
		return false;
	}).bind('dragover', function(){
	// デフォルトの挙動を停止
		return false;
	});

	/*================================================
	ダミーボタンを押した時の処理
	=================================================*/
	$('#uploadbtn').click(function() {
	// ダミーボタンとinput[type="file"]を連動
	//$('.btn-group input[type="file"]').click().change();
	$('.btn-group input[type="file"]').click().change();
		return false;
	});

	$('.btn-group input[type="file"]').change(function(){
		// ファイル情報を取得
		var files = this.files;

		//alert(this.files[0].name);
		if( typeof FormData == 'function'){
			uploadFiles(files);
		}
	});

	// 互換性対応
	if( typeof FormData != 'function'){
		$('#uploadbtn').css('display','none');
		$('#uploaddrop').css('display','none');
		$('#uploadinput').css('display','inline');
		$('#uploadsugmit').css('display','inline');
	}else{
		$('#uploaddrop').css('display','inline');
		$('#uploadbtn').css('display','inline');
	}
});

function trimStr(str,byteSize){
	var cnt = 0,trimStr="";
	for (var j=0,len=str.length; j <len ; j++) {
		str.charCodeAt(j) < 0x100 ? cnt++ : cnt += 2;
		trimStr +=str.charAt(j)
		if(cnt>=byteSize){
			trimStr = trimStr.substr(0,j-2)+"..."
			break;
		}
	}
	return trimStr;
}
/*================================================
  アップロード処理
=================================================*/
function uploadFiles(files,count) {
	$('#completeStatus').html('');
	if( ! files[0]){
		return;
	}
	var fileName = files[0].name;
	if(files.length == 1){
		fileName = trimStr(fileName,30);
	}else{
		fileName = trimStr(fileName,26)+ "("+files.length+")";
	}
	// FormDataオブジェクトを用意
	var fd = new FormData();

	// ファイルの個数を取得
	var filesLength = files.length;

	// ファイル情報を追加
	for (var i = 0; i < filesLength; i++) {
		fd.append("FILE_01", files[i]);
 	}

 	$('#uploadform input[type!="file"], #uploadform input[type!="hidden"], #uploadform select, #uploadform textarea').each(function(){
			fd.append(this.name,this.value);
		}
	);


	// HTML5フラグ
	fd.append("OG_HTML5","true");

	// Ajaxでアップロード処理をするファイルへ内容渡す
	// multipartのboundaryの問題があるのでIE及びEdgeのみの対応となる。
	// contentTypeをfalseにしてもうまく動作しないため、
	// Chromiumの場合はエンジン側での対応が必要か？？
	$.ajax({
		url: 'upload2.jsp',
		type: 'POST',
		data: fd,
		processData: false,
		contentType: "multipart/form-data",
		success: function(data) {
			console.log('file uploade success.');
			//console.log(data);
			if( data.indexOf("<error>") > 0){
				console.log(data);
				$('#status').html(data);
				return;
			}
			$('#file'+count).html('<progress max="100" value="100" style="width:100px;" />　完了<span style ="font-size: x-small;">'+fileName+'</span> ');
			//3秒後にアップロードバーを消してすべて消えた場合'完了'を表示させる
	//		var hoge = setInterval(function() {
	//			$('#file'+count).remove();
	//			if($('.statusBar').length==0){
	//				$('#completeStatus').html('<progress max="100" value="100"  style="width:100px;"/>　完了');
	//			}
	//			clearInterval(hoge);
	//		}, 3000);
			$('#uploadinfo').append('<br/>' + data );
			if(window.parent.FILES){
				//window.parent.FILES.location.reload(); // 存在すればRESULTのリロードを行う
				window.parent.FILES.location = document.getElementById("RESULTURL").value;
			}
		},
		error: function(data,err) {
			console.log('file uploade error.');
			console.log(data.responseText + "/"  + err);
			$('#uploadinfo').append(data.responseText);
		},
		xhr: function() {
			$('#status').append('<div id = file'+count+' class = "statusBar">');
			var xhr = new window.XMLHttpRequest();

			// アップロードの進捗状況を取得
			xhr.upload.addEventListener("progress", function(event) {
				if (event.lengthComputable) {
					$('#file'+count).html( '<progress max="100" value="'
											+ parseInt(parseInt((event.loaded / event.total) * 100))
											+ '" /> ' + parseInt(parseInt((event.loaded / event.total) * 99))
								//			+ '% wait...<img src="icon_loader_a_gw_03_s1.gif" />'
											+ '<span style ="font-size: x-small;">' + fileName+'</span>');
				}
			}, false);
			// 中止の際に何かしたい場合
			xhr.addEventListener("abort", function(event) {
			}, false);
		return xhr;
		}
	});
}
