/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.HybsDateUtil;

public final class DBUpdater {
    private final PreparedStatement pstmt;
    private final boolean usePMeta;
    private final int[] types;
    private final boolean[] isTime;
    private final boolean useSelect;
    private int rowCnt;
    private int updCnt;

    public DBUpdater(int n, PreparedStatement preparedStatement) {
        this(n, preparedStatement, true);
    }

    public DBUpdater(int n, PreparedStatement preparedStatement, boolean bl) {
        this(n, preparedStatement, bl, null);
    }

    public DBUpdater(int n, PreparedStatement preparedStatement, boolean bl, boolean[] blArray) {
        this(n, preparedStatement, bl, blArray, false);
    }

    public DBUpdater(int n, PreparedStatement preparedStatement, boolean bl, boolean[] blArray, boolean bl2) {
        this.usePMeta = bl;
        this.pstmt = preparedStatement;
        this.isTime = blArray;
        this.useSelect = bl2;
        if (bl) {
            this.types = new int[n];
            try {
                ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
                for (int i = 0; i < n; ++i) {
                    this.types[i] = parameterMetaData.getParameterType(i + 1);
                }
            }
            catch (SQLException sQLException) {
                throw new OgRuntimeException("ParameterMetaData \u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", sQLException);
            }
        } else {
            this.types = null;
        }
    }

    public void execute(String[] stringArray) throws SQLException {
        if (stringArray != null && stringArray.length > 0) {
            int n;
            ++this.rowCnt;
            if (this.usePMeta) {
                for (n = 0; n < stringArray.length; ++n) {
                    String string = stringArray[n];
                    if (string == null || string.isEmpty()) {
                        this.pstmt.setNull(n + 1, this.types[n]);
                        continue;
                    }
                    this.pstmt.setObject(n + 1, (Object)string, this.types[n]);
                }
            } else if (this.isTime == null) {
                for (n = 0; n < stringArray.length; ++n) {
                    String string = stringArray[n];
                    this.pstmt.setObject(n + 1, string);
                }
            } else {
                for (n = 0; n < stringArray.length; ++n) {
                    String string = stringArray[n];
                    if (this.isTime[n] && string != null && !string.isEmpty()) {
                        Timestamp timestamp = Timestamp.valueOf(HybsDateUtil.parseTimestamp(string));
                        this.pstmt.setObject(n + 1, timestamp);
                        continue;
                    }
                    this.pstmt.setObject(n + 1, string);
                }
            }
            this.pstmt.addBatch();
            if (this.rowCnt % 100 == 0) {
                int[] nArray = this.pstmt.executeBatch();
                this.updCnt += nArray.length;
            }
        }
    }

    public int update(String[] stringArray) throws SQLException {
        int n = 0;
        if (stringArray != null && stringArray.length > 0) {
            int n2;
            ++this.rowCnt;
            if (this.usePMeta) {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    String string = stringArray[n2];
                    if (string == null || string.isEmpty()) {
                        this.pstmt.setNull(n2 + 1, this.types[n2]);
                        continue;
                    }
                    this.pstmt.setObject(n2 + 1, (Object)string, this.types[n2]);
                }
            } else if (this.isTime == null) {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    String string = stringArray[n2];
                    this.pstmt.setObject(n2 + 1, string);
                }
            } else {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    String string = stringArray[n2];
                    if (this.isTime[n2] && string != null && !string.isEmpty()) {
                        Timestamp timestamp = Timestamp.valueOf(HybsDateUtil.parseTimestamp(string));
                        this.pstmt.setObject(n2 + 1, timestamp);
                        continue;
                    }
                    this.pstmt.setObject(n2 + 1, string);
                }
            }
            if (this.useSelect) {
                ResultSet resultSet = this.pstmt.executeQuery();
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
            } else {
                n = this.pstmt.executeUpdate();
            }
        }
        return n;
    }

    public int execEnd() throws SQLException {
        int[] nArray = this.pstmt.executeBatch();
        this.updCnt += nArray.length;
        return this.updCnt;
    }
}

