/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.table;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

class StandardDeviation {
    private static final String VERSION = "7.3.0.0 (2021/01/06)";
    private static final String[] ZERO_ARY = new String[0];
    public static final String[] ADD_CLMS = new String[]{"CNT", "SUM", "AVG", "STDEV", "COEFF", "M3S", "M2S", "M1S", "M0S", "P0S", "P1S", "P2S", "P3S"};
    private static final int HIST_SU = 8;
    private final List<Double> data = new ArrayList<Double>();
    private final int ftype;
    private final boolean useDEVP;
    private final String format;
    private final double minCV;
    private double sum;
    private double pow;

    public StandardDeviation(int n, boolean bl, String string, String string2) {
        this.ftype = n;
        this.useDEVP = bl;
        this.format = string;
        this.minCV = this.parseDouble(string2);
    }

    public void clear() {
        this.data.clear();
        this.sum = 0.0;
        this.pow = 0.0;
    }

    public void addData(String string) {
        double d = this.parseDouble(string);
        if (d != 0.0) {
            this.data.add(d);
            this.sum += d;
            this.pow += d * d;
        }
    }

    public String[] getData() {
        boolean bl;
        int n = this.data.size();
        if (n == 0) {
            return ZERO_ARY;
        }
        double d = this.sum / (double)n;
        double d2 = Math.abs(this.pow / (double)n - d * d);
        double d3 = this.useDEVP ? Math.sqrt(d2) : (n == 1 ? 0.0 : Math.sqrt(d2 * (double)n / (double)(n - 1)));
        double d4 = d3 / d * 100.0;
        if (d4 < this.minCV) {
            return ZERO_ARY;
        }
        double d5 = this.halfUp(d3);
        double d6 = d5 * 2.0;
        double d7 = d5 * 3.0;
        int[] nArray = new int[8];
        for (double d8 : this.data) {
            double d9 = this.halfUp(d8 - d);
            if (n == 1 || 0.0 == d9 || 0.0 == d5) {
                nArray[4] = nArray[4] + 1;
                continue;
            }
            if (0.0 <= d9 && d9 < d5) {
                nArray[4] = nArray[4] + 1;
                continue;
            }
            if (-0.0 == d9) {
                nArray[3] = nArray[3] + 1;
                continue;
            }
            if (-d5 <= d9 && d9 < 0.0) {
                nArray[3] = nArray[3] + 1;
                continue;
            }
            if (d5 <= d9 && d9 < d6) {
                nArray[5] = nArray[5] + 1;
                continue;
            }
            if (-d6 <= d9 && d9 < -d5) {
                nArray[2] = nArray[2] + 1;
                continue;
            }
            if (d6 <= d9 && d9 < d7) {
                nArray[6] = nArray[6] + 1;
                continue;
            }
            if (-d7 <= d9 && d9 < -d6) {
                nArray[1] = nArray[1] + 1;
                continue;
            }
            if (d7 <= d9) {
                nArray[7] = nArray[7] + 1;
                continue;
            }
            if (!(d9 < -d7)) continue;
            nArray[0] = nArray[0] + 1;
        }
        switch (this.ftype) {
            case 1: {
                bl = nArray[0] + nArray[1] + nArray[2] + nArray[5] + nArray[6] + nArray[7] > 0;
                break;
            }
            case 2: {
                bl = nArray[0] + nArray[1] + nArray[6] + nArray[7] > 0;
                break;
            }
            case 3: {
                bl = nArray[0] + nArray[7] > 0;
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            String[] stringArray = new String[ADD_CLMS.length];
            stringArray[0] = String.valueOf(n);
            stringArray[1] = String.format(this.format, this.sum);
            stringArray[2] = String.format(this.format, d);
            stringArray[3] = String.format(this.format, d3);
            stringArray[4] = String.format("%.2f", d4);
            stringArray[5] = String.valueOf(nArray[0]);
            stringArray[6] = String.valueOf(nArray[1]);
            stringArray[7] = String.valueOf(nArray[2]);
            stringArray[8] = String.valueOf(nArray[3]);
            stringArray[9] = String.valueOf(nArray[4]);
            stringArray[10] = String.valueOf(nArray[5]);
            stringArray[11] = String.valueOf(nArray[6]);
            stringArray[12] = String.valueOf(nArray[7]);
            return stringArray;
        }
        return ZERO_ARY;
    }

    private double parseDouble(String string) {
        double d = 0.0;
        if (string != null && !string.trim().isEmpty()) {
            try {
                d = Double.parseDouble(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = "\u6587\u5b57\u5217\u3092\u6570\u5024\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002val=[" + string + "]" + numberFormatException.getMessage();
                System.out.println(string2);
            }
        }
        return d;
    }

    private double halfUp(double d) {
        return BigDecimal.valueOf(d).setScale(3, RoundingMode.HALF_UP).doubleValue();
    }
}

