<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useAjaxSubmit="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC20"
	title	= "環境管理ﾃｰﾌﾞﾙ"
	date	= "2013/08/20"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>
<og:columnCheck
	command		= "{@command}"
/>

<og:dbConfigEditor command="GET" type="DBID" />

<og:tableMerge
	action			= "ADD_CLM"
	unionClms		= "CNTXT_ID,SYSTEM_ID,TBLSYU,NMSYS,DBID,DB_URL,DB_USER,DB_PASS,FGJ,UNIQ"
/>

<!-- forward.jsp から command がセットされて遷移してきます。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="ALLACTION" useConsistency="false">
	<og:columnSet command="ALLACTION" columnId="CNTXT_ID"	action="COPY"	value="dbidKey"		/>
	<og:columnSet command="ALLACTION" columnId="SYSTEM_ID"	action="COPY"	value="dbidKey"		/>
	<og:columnSet command="ALLACTION" columnId="SYSTEM_ID"	action="PREFIX"	value="_"			/>
	<og:columnSet command="ALLACTION" columnId="DBID"		action="COPY"	value="dbidKey"		/>
	<og:columnSet command="ALLACTION" columnId="TBLSYU"		action="COPY"	value="dbidKey"		/>
	<og:columnSet command="ALLACTION" columnId="TBLSYU"		action="SUFIX"	value="_"			/>
	<og:columnSet command="ALLACTION" columnId="DB_URL"		action="COPY"	value="url"			/>
	<og:columnSet command="ALLACTION" columnId="DB_USER"	action="COPY"	value="user"		/>
	<og:columnSet command="ALLACTION" columnId="DB_PASS"	action="COPY"	value="password"	/>
	<og:columnSet command="ALLACTION" columnId="FGJ"		action="SET"	value="1"			/>
</og:entry>

<og:columnEditor columns="SYSTEM_ID,TBLSYU" must="true" />

<form method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンと、EXCEL(CSV)変更リンクを作成します。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="entry" lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset" lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
<br />
</og:writeCheck>

<!-- 入力画面を表示します。 -->
<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	columnDisplay  = "SYSTEM_ID,TBLSYU,TITLE,NMSYS,DBID,DB_URL,DB_USER,DB_PASS"
	columnWritable = "SYSTEM_ID,TBLSYU"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />

<og:hidden name="sqlType" value="INSERT" />

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
