<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "ORA09"
	title	= "SQL洗い出し"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" debug="{@debug}" dbid="{@DBID}" maxRowCount="{@maxRowCount}">
		select
			SORTS			as "SORT回数"				,
			FETCHES			as "FETCHの回数"			,
			EXECUTIONS		as "実行回数"				,
			PARSE_CALLS		as "解析コールの回数"		,
			DISK_READS		as "ディスク読み込み数"		,
			BUFFER_GETS		as "バッファ読み込み数"		,
			ROWS_PROCESSED	as "SQLが戻す行数"			,
			LOADS			,
			CPU_TIME		as "CPU時間(μs)"			,
			ELAPSED_TIME	as "経過時間(μs)"			,
			SQL_FULLTEXT	,
			SQL_ID			,
			FIRST_LOAD_TIME	,
			LAST_LOAD_TIME	,
			LAST_ACTIVE_TIME	,
			OPTIMIZER_MODE	,
			OPTIMIZER_COST	,
			PARSING_SCHEMA_NAME	,
			MODULE
		from
		   V$SQL
		<og:appear startKey = "ORDER BY" value = "{@SQL_ORDER_BY}"
				defaultVal = "CPU_TIME DESC" />
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="SQL_ID" gamenId="ORA09" href="display.jsp" target="RESULT"
		keys="command,SQL_ID,DBID"
		vals="NEW,[SQL_ID],{@DBID}" />
</og:viewLink>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	writable   = "false"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
