/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.table;

import org.opengion.fukurou.util.ErrMsg;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.AbstractTableFilter;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.resource.ResourceFactory;
import org.opengion.hayabusa.resource.ResourceManager;

public class TableFilter_JUDG
extends AbstractTableFilter {
    private static final String VERSION = "7.4.2.3 (2021/06/09)";
    private int noVal = -1;
    private int noJudg = -1;
    private int noRiyu = -1;
    private int noType = -1;
    private int noCdrec = -1;
    private int noEmin = -1;
    private int noWmin = -1;
    private int noWmax = -1;
    private int noEmax = -1;
    private DBTableModel table;

    public DBTableModel execute() {
        this.table = this.getDBTableModel();
        if (this.table == null) {
            return this.table;
        }
        ResourceManager resourceManager = ResourceFactory.newInstance((String)"ja");
        this.noVal = this.table.getColumnNo("VAL");
        this.noJudg = this.table.getColumnNo("JUDG");
        this.noRiyu = this.table.getColumnNo("RIYU");
        this.noType = this.table.getColumnNo("DATA_TYPE", false);
        this.noCdrec = this.table.getColumnNo("CDREC", false);
        this.noEmin = this.table.getColumnNo("E_MIN", false);
        this.noWmin = this.table.getColumnNo("W_MIN", false);
        this.noWmax = this.table.getColumnNo("W_MAX", false);
        this.noEmax = this.table.getColumnNo("E_MAX", false);
        int n = this.table.getRowCount();
        for (int i = 0; i < n; ++i) {
            String[] stringArray = (String[])this.table.getValues(i);
            String string = stringArray[this.noVal];
            String string2 = stringArray[this.noJudg];
            String string3 = this.rowData(i, this.noCdrec, "0");
            if (string == null || string.isEmpty() || "1".equals(string3) || "2".equals(string3)) {
                stringArray[this.noJudg] = string3;
            } else {
                String string4 = this.rowData(i, this.noType, "TP_TEXT");
                if ("TP_ON".equals(string4)) {
                    stringArray[this.noJudg] = "1".equals(string) ? "3" : ("0".equals(string) ? "0" : ("3".equals(string) ? "4" : "7"));
                } else if ("TP_CHECK".equals(string4)) {
                    stringArray[this.noJudg] = "1".equals(string) ? "3" : string3;
                } else if ("TP_INT".equals(string4) || "TP_REAL".equals(string4)) {
                    double d = this.rowData(i, this.noEmin, Double.NEGATIVE_INFINITY);
                    double d2 = this.rowData(i, this.noWmin, Double.NEGATIVE_INFINITY);
                    double d3 = this.rowData(i, this.noWmax, Double.POSITIVE_INFINITY);
                    double d4 = this.rowData(i, this.noEmax, Double.POSITIVE_INFINITY);
                    try {
                        String string5 = StringUtil.deleteChar((String)string, (char)',');
                        double d5 = Double.parseDouble(string5);
                        if (d > d5) {
                            stringArray[this.noJudg] = "7";
                            stringArray[this.noRiyu] = String.format("\u4e0b\u9650\u5024(%.2f)\u7570\u5e38 [ \uff1e %.2f ]", d, d5);
                        } else if (d4 < d5) {
                            stringArray[this.noJudg] = "7";
                            stringArray[this.noRiyu] = String.format("\u4e0a\u9650\u5024(%.2f)\u7570\u5e38 [ \uff1c %.2f ]", d4, d5);
                        } else if (d2 > d5) {
                            stringArray[this.noJudg] = "5";
                            stringArray[this.noRiyu] = String.format("\u4e0b\u9650\u5024(%.2f)\u8b66\u544a [ \uff1e %.2f ]", d2, d5);
                        } else if (d3 < d5) {
                            stringArray[this.noJudg] = "5";
                            stringArray[this.noRiyu] = String.format("\u4e0a\u9650\u5024(%.2f)\u8b66\u544a [ \uff1c %.2f ]", d3, d5);
                        } else {
                            stringArray[this.noJudg] = "3";
                            stringArray[this.noRiyu] = "";
                        }
                        stringArray[this.noVal] = string5;
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringArray[this.noJudg] = "7";
                        stringArray[this.noRiyu] = "\u6570\u5024\u5909\u63db\uff74\uff97\uff70 " + string;
                    }
                } else {
                    DBColumn dBColumn = resourceManager.makeDBColumn(string4);
                    try {
                        stringArray[this.noVal] = dBColumn.valueSet(string);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    ErrorMessage errorMessage = dBColumn.valueCheck(string, false);
                    if (errorMessage == null || errorMessage.isOK()) {
                        stringArray[this.noJudg] = "3";
                        stringArray[this.noRiyu] = "";
                    } else {
                        StringBuilder stringBuilder = new StringBuilder(200).append("<div class='small'>");
                        for (ErrMsg errMsg : errorMessage.toArray()) {
                            stringBuilder.append(resourceManager.getShortErrorMsg(errMsg));
                        }
                        stringArray[this.noRiyu] = stringBuilder.append("</div>").toString();
                        stringArray[this.noJudg] = errorMessage.getKekka() == 1 ? "5" : "7";
                    }
                }
            }
            if (!"4".equals(string2) || !"5".equals(stringArray[this.noJudg]) && !"7".equals(stringArray[this.noJudg])) continue;
            stringArray[this.noJudg] = "4";
        }
        return this.table;
    }

    private String rowData(int n, int n2, String string) {
        String string2;
        String string3 = string;
        if (n2 >= 0 && (string2 = (String)this.table.getValue(n, n2)) != null && !string2.isEmpty()) {
            string3 = string2;
        }
        return string3;
    }

    private double rowData(int n, int n2, double d) {
        String string = n2 < 0 ? null : (String)this.table.getValue(n, n2);
        try {
            return string == null || string.isEmpty() ? d : Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = "\u6570\u5024\u9805\u76ee\u306e\u6570\u5024\u5909\u63db\uff74\uff97\uff70\u3000\u884c=" + n + " , \u5217=" + n2 + " , \u5024=" + string;
            throw new HybsSystemException(string2, (Throwable)numberFormatException);
        }
    }
}

