/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report.ExcelLayoutData;

class ExcelLayoutDataIterator
implements Iterator<ExcelLayoutData> {
    private final ExcelLayoutData[] layoutDatas;
    private final String loopClm;
    private final int incSize;
    private int count;
    private int edbnCnt;
    private int stAdrs = -1;
    private int edAdrs = -1;

    public ExcelLayoutDataIterator(ExcelLayoutData[] excelLayoutDataArray, String string) {
        this.layoutDatas = excelLayoutDataArray;
        this.loopClm = string;
        int n = this.layoutDatas.length;
        int n2 = 1;
        Arrays.sort(this.layoutDatas);
        if (this.loopClm != null) {
            int n3 = -1;
            for (int i = 0; i < n; ++i) {
                int n4 = this.layoutDatas[i].getEdbn();
                if (this.stAdrs < 0 && n4 == 0) {
                    this.stAdrs = i;
                }
                if (this.edAdrs < 0 && n4 == 1) {
                    this.edAdrs = i;
                }
                if (!this.loopClm.equals(this.layoutDatas[i].getClm())) continue;
                if (n4 == 0) {
                    n3 = this.layoutDatas[i].getRowNo();
                    continue;
                }
                if (n4 != 1) continue;
                n2 = this.layoutDatas[i].getRowNo() - n3;
                break;
            }
            if (n3 < 0 && this.stAdrs >= 0) {
                String string2 = "\u7e70\u8fd4\u5fc5\u9808\u30ab\u30e9\u30e0\u304c\u30b7\u30fc\u30c8\u4e2d\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002[" + this.loopClm + "]";
                throw new HybsSystemException(string2);
            }
        }
        if (this.stAdrs < 0) {
            this.stAdrs = 0;
        }
        if (this.edAdrs < 0) {
            this.edAdrs = n;
        }
        this.incSize = n2;
    }

    @Override
    public boolean hasNext() {
        if (this.loopClm != null && this.count == this.edAdrs) {
            this.count = this.stAdrs;
            ++this.edbnCnt;
        }
        return this.count < this.edAdrs;
    }

    @Override
    public ExcelLayoutData next() throws NoSuchElementException {
        if (this.layoutDatas == null || this.layoutDatas.length == this.count) {
            String string = "\u884c\u756a\u53f7\u304c\u30ec\u30a4\u30a2\u30a6\u30c8\u30c7\u30fc\u30bf\u3092\u30aa\u30fc\u30d0\u30fc\u3057\u307e\u3057\u305f\u3002 \u884c\u756a\u53f7=[" + this.count + "]";
            throw new NoSuchElementException(string);
        }
        ExcelLayoutData excelLayoutData = this.layoutDatas[this.count++];
        if (this.edbnCnt > 0) {
            int n = excelLayoutData.getRowNo() + this.edbnCnt * this.incSize;
            excelLayoutData = excelLayoutData.copy(n, this.edbnCnt);
        }
        return excelLayoutData;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("\u3053\u306e\u30e1\u30bd\u30c3\u30c9\u306f\u3001\u3053\u306e\u30af\u30e9\u30b9\u304b\u3089\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
    }

    public void setEnd() {
        this.edAdrs = -1;
    }
}

