/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.DateSet;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;

public class Shell {
    public static final int OK = 0;
    public static final int RUNNING = 1;
    public static final int CANCEL = 9;
    public static final int ERROR = -1;
    private static final String CMD_NT = "C:\\WINNT\\system32\\cmd.exe /c ";
    private static final String CMD_XP = "C:\\WINDOWS\\system32\\cmd.exe /c ";
    private static final String OS_NAME = System.getProperty("os.name");
    private String command;
    private File workDir;
    private String[] envp;
    private boolean isWait = true;
    private Process prcs;
    private ProcessReader pr1;
    private ProcessReader pr2;
    private int rtnCode = -1;
    private long timeout;
    private static final String CMD_COM = (OS_NAME.indexOf("NT") >= 0 || OS_NAME.indexOf("2000") >= 0) && OS_NAME.indexOf("unknown") < 0 ? "C:\\WINNT\\system32\\cmd.exe /c " : "C:\\WINDOWS\\system32\\cmd.exe /c ";

    public void setCommand(String string, boolean bl) {
        this.command = bl ? CMD_COM + string : string;
    }

    public void setCommand(String string) {
        this.setCommand(string, false);
    }

    public void setWait(boolean bl) {
        this.isWait = bl;
    }

    public void setTimeout(int n) {
        this.timeout = (long)n * 1000L;
    }

    public void setWorkDir(File file) {
        this.workDir = file;
    }

    public void setEnvP(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            this.envp = new String[n];
            System.arraycopy(stringArray, 0, this.envp, 0, n);
        } else {
            this.envp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exec() {
        Runtime runtime = Runtime.getRuntime();
        Thread thread = null;
        try {
            this.prcs = runtime.exec(this.command, this.envp, this.workDir);
            this.pr1 = new ProcessReader(this.prcs.getInputStream());
            this.pr1.start();
            this.pr2 = new ProcessReader(this.prcs.getErrorStream());
            this.pr2.start();
            if (this.isWait) {
                thread = new WaitJoin(this.timeout, this.prcs);
                thread.start();
                this.rtnCode = this.prcs.waitFor();
                if (this.rtnCode > 0) {
                    this.rtnCode = -this.rtnCode;
                }
            } else {
                this.rtnCode = 1;
            }
        }
        catch (IOException iOException) {
            LogWriter.log("\u5165\u51fa\u529b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
            LogWriter.log(iOException);
        }
        catch (InterruptedException interruptedException) {
            LogWriter.log("\u73fe\u5728\u306e\u30b9\u30ec\u30c3\u30c9\u304c\u5f85\u6a5f\u4e2d\u306b\u307b\u304b\u306e\u30b9\u30ec\u30c3\u30c9\u306b\u3088\u3063\u3066\u5f37\u5236\u7d42\u4e86\u3055\u308c\u307e\u3057\u305f\u3002");
            LogWriter.log(interruptedException);
        }
        finally {
            if (thread != null) {
                thread.interrupt();
            }
        }
        return this.rtnCode;
    }

    public String getStdoutData() {
        Object object = this.pr1 == null ? "\n.......... Process is not Running. ...." : (this.pr1.isEnd() ? this.pr1.getString() : this.pr1.getString() + "\n......... stdout Process is under execution. ...");
        return object;
    }

    public String getStderrData() {
        Object object = this.pr2 == null ? "\n.......... Process is not Running. ...." : (this.pr2.isEnd() ? this.pr2.getString() : this.pr2.getString() + "\n......... stderr Process is under execution. ...");
        return object;
    }

    public String getCommand() {
        return this.command;
    }

    public void destroy() {
        if (this.prcs != null) {
            this.prcs.destroy();
        }
        this.rtnCode = 9;
    }

    public boolean isEnd() {
        boolean bl = true;
        if (this.rtnCode == 1) {
            if (this.pr1 == null || this.pr2 == null) {
                String string = "#exec()\u3092\u5148\u306b\u5b9f\u884c\u3057\u3066\u304a\u3044\u3066\u304f\u3060\u3055\u3044\u3002" + HybsConst.CR + "   command =" + this.command;
                throw new OgRuntimeException(string);
            }
            boolean bl2 = bl = this.pr1.isEnd() && this.pr2.isEnd();
            if (bl) {
                this.rtnCode = 0;
            }
        }
        return bl;
    }

    public int exitValue() {
        if (this.prcs == null) {
            String string = "#exec()\u3092\u5148\u306b\u5b9f\u884c\u3057\u3066\u304a\u3044\u3066\u304f\u3060\u3055\u3044\u3002" + HybsConst.CR + "   command =" + this.command;
            throw new OgRuntimeException(string);
        }
        if (this.rtnCode == 1 && this.isEnd()) {
            this.rtnCode = this.prcs.exitValue();
            if (this.rtnCode > 0) {
                this.rtnCode = -this.rtnCode;
            }
        }
        return this.rtnCode;
    }

    public String toString() {
        if (this.pr1 == null) {
            String string = "#exec()\u3092\u5148\u306b\u5b9f\u884c\u3057\u3066\u304a\u3044\u3066\u304f\u3060\u3055\u3044\u3002" + HybsConst.CR + "   command =" + this.command;
            throw new OgRuntimeException(string);
        }
        boolean bl = this.isEnd();
        String string = DateSet.getDate(this.pr1.getStartTime(), "yyyy/MM/dd HH:mm:ss");
        String string2 = bl ? DateSet.getDate(this.pr1.getEndTime(), "yyyy/MM/dd HH:mm:ss") : "----/--/-- --:--:--";
        StringBuilder stringBuilder = new StringBuilder(200).append("command     = [").append(this.getCommand()).append(']').append(HybsConst.CR).append("  isEnd     = [").append(bl).append(']').append(HybsConst.CR).append("  rtnCode   = [").append(this.exitValue()).append(']').append(HybsConst.CR).append("  startTime = [").append(string).append(']').append(HybsConst.CR).append("  endTime   = [").append(string2).append(']').append(HybsConst.CR);
        return stringBuilder.toString();
    }

    private static final class WaitJoin
    extends Thread {
        private static final long MAX_WAIT = 3600000L;
        private final long wait;
        private final Process prcs;

        WaitJoin(long l, Process process) {
            this.wait = l > 0L ? l : 3600000L;
            this.prcs = process;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long l = System.currentTimeMillis();
                boolean bl = true;
                WaitJoin waitJoin = this;
                synchronized (waitJoin) {
                    while (!this.isInterrupted() && bl) {
                        this.wait(this.wait);
                        bl = l + this.wait > System.currentTimeMillis();
                    }
                }
                this.prcs.destroy();
                System.out.println("\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u306b\u3088\u308a\u5f37\u5236\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (InterruptedException interruptedException) {
                LogWriter.log("\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
        }
    }

    private static final class ProcessReader
    extends Thread {
        private final BufferedReader in;
        private final StringBuilder inStream = new StringBuilder(200);
        private long startTime = -1L;
        private long endTime = -1L;
        private boolean endFlag;

        ProcessReader(InputStream inputStream) {
            this.in = new BufferedReader(new InputStreamReader(inputStream, HybsConst.DEFAULT_CHARSET));
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.startTime = System.currentTimeMillis();
            try {
                String string;
                while ((string = this.in.readLine()) != null) {
                    this.inStream.append(string);
                    this.inStream.append(HybsConst.CR);
                }
            }
            catch (IOException iOException) {
                LogWriter.log("\u5165\u51fa\u529b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
                LogWriter.log(iOException);
            }
            finally {
                Closer.ioClose(this.in);
            }
            this.endTime = System.currentTimeMillis();
            this.endFlag = true;
        }

        String getString() {
            return this.inStream.toString();
        }

        boolean isEnd() {
            return this.endFlag;
        }

        long getStartTime() {
            return this.startTime;
        }

        long getEndTime() {
            return this.endTime;
        }
    }
}

