/****************************************************************************/
/* SYSTEM_ID : GE                                                           */
/* GEP1001 ( PROCEDURE )                                                    */
/* Created : 2021/06/29 13:33:28                                            */
/****************************************************************************/

CREATE 
PROCEDURE GEP1001 (
/*******************************************************************************
*	ｼｽﾃﾑ			:	GMIS生産管理ｼｽﾃﾑVer6
*	ﾌﾟﾛｸﾞﾗﾑID		:	GEP1001
*	処理名			:	共通SP雛形
*	作成日			:	YYYY/MM/DD
*	作成者			:	XXXXXXX
*	更新日/更新者	:
*	更新内容		:
*******************************************************************************/
	 PO_STATUS		OUT		NUMBER											-- ｽﾃｰﾀｽ(0:正常 2:異常)
	,PO_ERR_CODE	OUT		VARCHAR2										-- ｴﾗｰﾒｯｾｰｼﾞ

	,PI_EXECID		IN		VARCHAR2										-- 処理ID
	,PI_FILE_NAME	IN		VARCHAR2										-- ﾌｧｲﾙ名
	,PI_PRM1		IN		VARCHAR2										-- ユーザー定義引数1
	,PI_PRM2		IN		VARCHAR2										-- ユーザー定義引数2
)
IS
/*******************************************************************************
*	変数宣言
*******************************************************************************/
	-- 定数定義

/*******************************************************************************
*	ﾒｲﾝ処理
*******************************************************************************/
BEGIN
	-- ｽﾃｰﾀｽ(2:異常)
	PO_STATUS := 2;
--
	update GE70 set RELEASE_NOTES=PI_PRM1 , RDC_CODE=PI_FILE_NAME || ',' || PI_PRM2
	where  SYSTEM_ID='GF' and EXECID=PI_EXECID ;
--

--
	-- ｽﾃｰﾀｽ(ｴﾗｰﾒｯｾｰｼﾞ配列のｴﾗｰ結果の最大)
	PO_STATUS := 0;
--

/*******************************************************************************
*	例外処理
*******************************************************************************/
EXCEPTION
	-- ｵﾗｸﾙｴﾗｰ
	WHEN OTHERS THEN
		-- ｽﾃｰﾀｽ(2:異常)
		PO_STATUS := 2;
		PO_ERR_CODE := TO_CHAR(SQLCODE) || SUBSTRB(SQLERRM,1,1000) ;
--
--
END GEP1001;
;
