/****************************************************************************/
/* GE12 ( ｼｽﾃﾑﾊﾟﾗﾒｰﾀ定義 )                                                  */
/*                                                                          */
/* Created : 2021/06/29 13:32:29                                            */
/****************************************************************************/

CREATE TABLE GE12 (
   SYSTEM_ID    VARCHAR2 (   10 )                       NOT NULL            /*  1 ｼｽﾃﾑID        */
 , PARAM_ID     VARCHAR2 (   50 )                       NOT NULL            /*  2 ﾊﾟﾗﾒｰﾀID      */
 , SEQNO        NUMBER   (    7 )       DEFAULT 0       NOT NULL            /*  3 表示順        */
 , TITLE        VARCHAR2 (  300 )                                           /*  4 ﾀｲﾄﾙ          */
 , PARAM        VARCHAR2 (  500 )                                           /*  5 設定値        */
 , CONTENTS     VARCHAR2 ( 4000 )                                           /*  6 内容          */
 , PARAM_LVL    VARCHAR2 (    1 )       DEFAULT '5'     NOT NULL            /*  7 設定ﾚﾍﾞﾙ      */
 , KBSAKU       VARCHAR2 (    1 )       DEFAULT '1'     NOT NULL            /*  8 作成区分      */
 , FGCRYPT      VARCHAR2 (    1 )       DEFAULT '0'     NOT NULL            /*  9 暗号化ﾌﾗｸﾞ    */
 , CONTXT_PATH  VARCHAR2 (   50 )       DEFAULT '**'    NOT NULL            /* 10 ｺﾝﾃｷｽﾄﾊﾟｽ     */
 , FGREBOOT     VARCHAR2 (    1 )       DEFAULT '0'                         /* 11 要再起動ﾌﾗｸﾞ  */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0       NOT NULL            /* 12 ﾕﾆｰｸｷｰ        */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1'     NOT NULL            /* 13 状態ﾌﾗｸﾞ      */
 , DYSET        VARCHAR2 (   14 )                                           /* 14 登録日時      */
 , PGSET        VARCHAR2 (   10 )                                           /* 15 作成PG        */
 , PGPSET       VARCHAR2 (   10 )                                           /* 16 作成親PG      */
 , USRSET       VARCHAR2 (   10 )                                           /* 17 作成社員      */
 , DYUPD        VARCHAR2 (   14 )                                           /* 18 更新日時      */
 , PGUPD        VARCHAR2 (   10 )                                           /* 19 更新PG        */
 , PGPUPD       VARCHAR2 (   10 )                                           /* 20 更新親PG      */
 , USRUPD       VARCHAR2 (   10 )                                           /* 21 更新者        */
)
TABLESPACE GFTBL01
STORAGE( INITIAL 448K );


CREATE SEQUENCE GE12S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE12T00 
  BEFORE INSERT ON GE12
  FOR EACH ROW 
  BEGIN 
    SELECT GE12S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
