/****************************************************************************/
/* GE15 ( ｱｸｾｽ調査ﾃｰﾌﾞﾙ )                                                   */
/*                                                                          */
/* Created : 2021/06/29 13:32:29                                            */
/****************************************************************************/

CREATE TABLE GE15 (
   SYSTEM_ID        VARCHAR2 (   10 )                   NOT NULL            /*  1 ｼｽﾃﾑID            */
 , USERID           VARCHAR2 (   10 )                   NOT NULL            /*  2 ﾕｰｻﾞｰID           */
 , GUIKEY           VARCHAR2 (   30 )                                       /*  3 画面ID            */
 , DYLOGIN          VARCHAR2 (   14 )                                       /*  4 ﾛｸﾞｲﾝ時間         */
 , DYLOGOUT         VARCHAR2 (   14 )                                       /*  5 ﾛｸﾞｱｳﾄ時間        */
 , USED_TIME        NUMBER   (    9 )       DEFAULT 0   NOT NULL            /*  6 使用時間(秒)      */
 , CNT_ACCESS       NUMBER   (    9 )       DEFAULT 0   NOT NULL            /*  7 ｱｸｾｽ件数          */
 , CNT_ERROR        NUMBER   (    5 )       DEFAULT 0   NOT NULL            /*  8 ｴﾗｰ件数           */
 , CNT_READ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /*  9 読込件数          */
 , CNT_WRITE        NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 10 出力件数          */
 , TM_TOTAL_QUERY   NUMBER   (   18 )       DEFAULT 0   NOT NULL            /* 11 ﾄｰﾀﾙDBｸｴﾘ時間(ms) */
 , TM_MAX_QUERY     NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 12 最大DBｸｴﾘ時間(ms) */
 , MAX_QUERY        VARCHAR2 ( 4000 )                                       /* 13 最長実行ｸｴﾘ       */
 , USERADRS         VARCHAR2 (   40 )                                       /* 14 IPｱﾄﾞﾚｽ(local)    */
 , HOSTADRS         VARCHAR2 (   40 )                                       /* 15 IPｱﾄﾞﾚｽ(remote)   */
 , UNIQ             NUMBER   (    9 )       DEFAULT 0   NOT NULL            /* 16 ﾕﾆｰｸｷｰ            */
 , FGJ              VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /* 17 状態ﾌﾗｸﾞ          */
 , DYSET            VARCHAR2 (   14 )                                       /* 18 登録日時          */
 , PGSET            VARCHAR2 (   10 )                                       /* 19 作成PG            */
 , PGPSET           VARCHAR2 (   10 )                                       /* 20 作成親PG          */
 , USRSET           VARCHAR2 (   10 )                                       /* 21 作成社員          */
 , DYUPD            VARCHAR2 (   14 )                                       /* 22 更新日時          */
 , PGUPD            VARCHAR2 (   10 )                                       /* 23 更新PG            */
 , PGPUPD           VARCHAR2 (   10 )                                       /* 24 更新親PG          */
 , USRUPD           VARCHAR2 (   10 )                                       /* 25 更新者            */
)
TABLESPACE GFTBL01
STORAGE( INITIAL 4096K );


CREATE SEQUENCE GE15S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE15T00 
  BEFORE INSERT ON GE15
  FOR EACH ROW 
  BEGIN 
    SELECT GE15S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
